/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.structure;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.structure.StructureMatcher;
import hellfirepvp.astralsorcery.common.util.Provider;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class StructureMatcherRegistry {
    public static final StructureMatcherRegistry INSTANCE = new StructureMatcherRegistry();
    private Map<ResourceLocation, Provider<StructureMatcher>> matcherRegistry = Maps.newHashMap();

    private StructureMatcherRegistry() {
    }

    public void register(Provider<StructureMatcher> matchProvider) {
        StructureMatcher match = matchProvider.provide();
        this.matcherRegistry.put(match.getRegistryName(), matchProvider);
    }

    @Nullable
    public StructureMatcher provideNewMatcher(ResourceLocation key) {
        Provider<StructureMatcher> provider = this.matcherRegistry.get(key);
        return provider == null ? null : provider.provide();
    }
}

