/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.network;

import hellfirepvp.astralsorcery.common.block.network.IBlockStarlightRecipient;
import hellfirepvp.astralsorcery.common.data.DataLightBlockEndpoints;
import hellfirepvp.astralsorcery.common.data.DataLightConnections;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.starlight.IIndependentStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.WorldNetworkHandler;
import hellfirepvp.astralsorcery.common.starlight.network.TransmissionWorldHandler;
import hellfirepvp.astralsorcery.common.starlight.transmission.IPrismTransmissionNode;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionReceiver;
import hellfirepvp.astralsorcery.common.starlight.transmission.NodeConnection;
import hellfirepvp.astralsorcery.common.util.CrystalCalculations;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class TransmissionChain {
    private List<ChunkPos> involvedChunks = new LinkedList<ChunkPos>();
    private List<LightConnection> foundConnections = new LinkedList<LightConnection>();
    private Map<BlockPos, Float> remainMultiplierMap = new HashMap<BlockPos, Float>();
    private List<BlockPos> uncheckedEndpointsBlock = new LinkedList<BlockPos>();
    private List<BlockPos> resolvedNormalBlockPositions = new LinkedList<BlockPos>();
    private List<ITransmissionReceiver> endpointsNodes = new LinkedList<ITransmissionReceiver>();
    private List<IPrismTransmissionNode> transmissionUpdateList = new LinkedList<IPrismTransmissionNode>();
    private final WorldNetworkHandler handler;
    private final IPrismTransmissionNode sourceNode;

    private TransmissionChain(WorldNetworkHandler netHandler, IPrismTransmissionNode sourceNode) {
        this.handler = netHandler;
        this.sourceNode = sourceNode;
    }

    public static void threadedBuildTransmissionChain(TransmissionWorldHandler handle, IIndependentStarlightSource source, WorldNetworkHandler netHandler, BlockPos sourcePos) {
        Thread tr = new Thread(() -> {
            TransmissionChain chain = TransmissionChain.buildFromSource(netHandler, sourcePos);
            handle.threadTransmissionChainCallback(chain, source, netHandler, sourcePos);
            DataLightConnections connections = (DataLightConnections)SyncDataHolder.getDataServer("StarlightNetworkConnections");
            connections.updateNewConnectionsThreaded(netHandler.getWorld().field_73011_w.getDimension(), chain.getFoundConnections());
            DataLightBlockEndpoints endpoints = (DataLightBlockEndpoints)SyncDataHolder.getDataServer("StarlightNetworkEndpoints");
            endpoints.updateNewEndpoints(netHandler.getWorld().field_73011_w.getDimension(), chain.resolvedNormalBlockPositions);
        });
        tr.setName("TrChainCalculationThread");
        tr.start();
    }

    private static TransmissionChain buildFromSource(WorldNetworkHandler netHandler, BlockPos at) {
        TransmissionChain chain = new TransmissionChain(netHandler, null);
        IPrismTransmissionNode node = netHandler.getTransmissionNode(at);
        if (node != null) {
            chain = new TransmissionChain(netHandler, node);
            chain.recBuildChain(node, 1.0f, new LinkedList<BlockPos>());
        }
        chain.calculateInvolvedChunks();
        chain.resolveLoadedEndpoints(netHandler.getWorld());
        return chain;
    }

    private void resolveLoadedEndpoints(World world) {
        for (BlockPos pos : this.uncheckedEndpointsBlock) {
            IBlockState state;
            Block b;
            if (!MiscUtils.isChunkLoaded(world, new ChunkPos(pos)) || (b = (state = world.func_180495_p(pos)).func_177230_c()) instanceof IBlockStarlightRecipient || this.resolvedNormalBlockPositions.contains(pos)) continue;
            this.resolvedNormalBlockPositions.add(pos);
        }
    }

    protected void updatePosAsResolved(World world, BlockPos pos) {
        if (this.uncheckedEndpointsBlock.contains(pos) && !this.resolvedNormalBlockPositions.contains(pos)) {
            this.resolvedNormalBlockPositions.add(pos);
            DataLightBlockEndpoints endpoints = (DataLightBlockEndpoints)SyncDataHolder.getDataServer("StarlightNetworkEndpoints");
            endpoints.updateNewEndpoint(world.field_73011_w.getDimension(), pos);
        }
    }

    private void recBuildChain(IPrismTransmissionNode node, float lossMultiplier, LinkedList<BlockPos> prevPath) {
        if (lossMultiplier <= 0.001f) {
            return;
        }
        CrystalProperties properties = node.getTransmissionProperties();
        float lossPerc = CrystalCalculations.getThroughputMultiplier(properties);
        List<NodeConnection<IPrismTransmissionNode>> next = node.queryNext(this.handler);
        float nextLoss = lossMultiplier * (lossPerc *= node.getAdditionalTransmissionLossMultiplier()) / (float)next.size();
        prevPath.push(node.getLocationPos());
        if (node.needsTransmissionUpdate() && !this.transmissionUpdateList.contains(node)) {
            this.transmissionUpdateList.add(node);
        }
        for (NodeConnection<IPrismTransmissionNode> nextNode : next) {
            IPrismTransmissionNode trNode = nextNode.getNode();
            if (!nextNode.canConnect()) continue;
            BlockPos nextPos = nextNode.getTo();
            this.addIfNonExistentConnection(node.getLocationPos(), nextPos);
            if (prevPath.contains(nextPos)) continue;
            Float currentLoss = this.remainMultiplierMap.get(nextPos);
            if (currentLoss != null) {
                this.remainMultiplierMap.put(nextPos, Float.valueOf(currentLoss.floatValue() + nextLoss));
            } else {
                this.remainMultiplierMap.put(nextPos, Float.valueOf(nextLoss));
            }
            if (trNode != null) {
                if (trNode instanceof ITransmissionReceiver) {
                    if (this.endpointsNodes.contains(trNode)) continue;
                    this.endpointsNodes.add((ITransmissionReceiver)trNode);
                    continue;
                }
                this.recBuildChain(trNode, nextLoss, prevPath);
                continue;
            }
            if (this.uncheckedEndpointsBlock.contains(nextPos)) continue;
            this.uncheckedEndpointsBlock.add(nextPos);
        }
        prevPath.pop();
    }

    private void calculateInvolvedChunks() {
        for (BlockPos nodePos : this.remainMultiplierMap.keySet()) {
            ChunkPos ch = new ChunkPos(nodePos);
            if (this.involvedChunks.contains(ch)) continue;
            this.involvedChunks.add(ch);
        }
    }

    public List<BlockPos> getResolvedNormalBlockPositions() {
        return this.resolvedNormalBlockPositions;
    }

    public IPrismTransmissionNode getSourceNode() {
        return this.sourceNode;
    }

    private void addIfNonExistentConnection(BlockPos start, BlockPos end) {
        LightConnection newCon = new LightConnection(start, end);
        if (!this.foundConnections.contains(newCon)) {
            this.foundConnections.add(newCon);
        }
    }

    public List<IPrismTransmissionNode> getTransmissionUpdateList() {
        return this.transmissionUpdateList;
    }

    public List<ChunkPos> getInvolvedChunks() {
        return this.involvedChunks;
    }

    public Map<BlockPos, Float> getLossMultipliers() {
        return this.remainMultiplierMap;
    }

    public List<LightConnection> getFoundConnections() {
        return this.foundConnections;
    }

    public List<ITransmissionReceiver> getEndpointsNodes() {
        return this.endpointsNodes;
    }

    public List<BlockPos> getUncheckedEndpointsBlock() {
        return this.uncheckedEndpointsBlock;
    }

    public static class LightConnection {
        private final BlockPos start;
        private final BlockPos end;

        public LightConnection(BlockPos start, BlockPos end) {
            this.start = start;
            this.end = end;
        }

        public BlockPos getStart() {
            return this.start;
        }

        public BlockPos getEnd() {
            return this.end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LightConnection that = (LightConnection)o;
            return !(this.end == null ? that.end != null : !this.end.equals((Object)that.end)) && !(this.start == null ? that.start != null : !this.start.equals((Object)that.start));
        }

        public int hashCode() {
            int result = this.start != null ? this.start.hashCode() : 0;
            result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
            return result;
        }
    }
}

