/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import hellfirepvp.astralsorcery.common.constellation.ConstellationBase;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.MoonPhase;
import hellfirepvp.astralsorcery.common.constellation.cape.CapeEffectRegistry;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectAevitas;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectArmara;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectBootes;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectDiscidia;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectEvorsio;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectFornax;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectHorologium;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectLucerna;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectMineralis;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectOctans;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectPelotrio;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectVicio;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.constellation.starmap.ConstellationMapEffectRegistry;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.event.APIRegistryEvent;
import hellfirepvp.astralsorcery.common.item.useables.ItemUsableDust;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.lib.EnchantmentsAS;
import hellfirepvp.astralsorcery.common.util.OreDictAlias;
import java.awt.Color;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class RegistryConstellations {
    public static void init() {
        RegistryConstellations.buildConstellations();
        RegistryConstellations.registerConstellations();
        MinecraftForge.EVENT_BUS.post((Event)new APIRegistryEvent.ConstellationRegister());
    }

    public static void initMapEffects() {
        RegistryConstellations.registerMapEffects();
        RegistryConstellations.registerCapeEffects();
    }

    public static void initConstellationSignatures() {
        RegistryConstellations.registerSignatureItems();
    }

    private static void registerCapeEffects() {
        CapeEffectRegistry.registerCapeArmorEffect(Constellations.discidia, CapeEffectDiscidia.class);
        CapeEffectRegistry.registerCapeArmorEffect(Constellations.aevitas, CapeEffectAevitas.class);
        CapeEffectRegistry.registerCapeArmorEffect(Constellations.evorsio, CapeEffectEvorsio.class);
        CapeEffectRegistry.registerCapeArmorEffect(Constellations.armara, CapeEffectArmara.class);
        CapeEffectRegistry.registerCapeArmorEffect(Constellations.vicio, CapeEffectVicio.class);
        CapeEffectRegistry.registerCapeArmorEffect(Constellations.lucerna, CapeEffectLucerna.class);
        CapeEffectRegistry.registerCapeArmorEffect(Constellations.fornax, CapeEffectFornax.class);
        CapeEffectRegistry.registerCapeArmorEffect(Constellations.mineralis, CapeEffectMineralis.class);
        CapeEffectRegistry.registerCapeArmorEffect(Constellations.pelotrio, CapeEffectPelotrio.class);
        CapeEffectRegistry.registerCapeArmorEffect(Constellations.octans, CapeEffectOctans.class);
        CapeEffectRegistry.registerCapeArmorEffect(Constellations.horologium, CapeEffectHorologium.class);
        CapeEffectRegistry.registerCapeArmorEffect(Constellations.bootes, CapeEffectBootes.class);
    }

    private static void registerMapEffects() {
        ConstellationMapEffectRegistry.registerMapEffect(Constellations.discidia, Arrays.asList(new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185302_k, 3, 7), new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185309_u, 3, 7)), Arrays.asList(new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76420_g, 0, 3)));
        ConstellationMapEffectRegistry.registerMapEffect(Constellations.armara, Arrays.asList(new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_180310_c, 3, 5)), Arrays.asList(new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76429_m)));
        ConstellationMapEffectRegistry.registerMapEffect(Constellations.vicio, Arrays.asList(new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_180309_e, 3, 5)), Arrays.asList(new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76424_c, 1, 3)));
        ConstellationMapEffectRegistry.registerMapEffect(Constellations.aevitas, Arrays.asList(new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185296_A, 1, 3)), Arrays.asList(new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76428_l, 0, 3)));
        ConstellationMapEffectRegistry.registerMapEffect(Constellations.evorsio, Arrays.asList(new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185305_q, 3, 5)), Arrays.asList(new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76422_e, 1, 3)));
        ConstellationMapEffectRegistry.registerMapEffect(Constellations.lucerna, Arrays.asList(new ConstellationMapEffectRegistry.EnchantmentMapEffect(EnchantmentsAS.enchantmentNightVision, 1, 1)), Arrays.asList(new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76439_r)));
        ConstellationMapEffectRegistry.registerMapEffect(Constellations.mineralis, Arrays.asList(new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185308_t, 1, 3)), Arrays.asList(new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76422_e, 0, 3)));
        ConstellationMapEffectRegistry.registerMapEffect(Constellations.horologium, Arrays.asList(new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185308_t, 4, 6), new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185304_p, 3, 5)), Arrays.asList(new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76422_e, 5, 8), new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76424_c, 1, 4)));
        ConstellationMapEffectRegistry.registerMapEffect(Constellations.octans, Arrays.asList(new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185298_f, 2, 4)), Arrays.asList(new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76427_o, 2, 4)));
        ConstellationMapEffectRegistry.registerMapEffect(Constellations.bootes, Arrays.asList(new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185306_r, 1, 1)), Arrays.asList(new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76443_y, 2, 5)));
        ConstellationMapEffectRegistry.registerMapEffect(Constellations.fornax, Arrays.asList(new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_77334_n, 1, 3), new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185311_w, 1, 2), new ConstellationMapEffectRegistry.EnchantmentMapEffect(EnchantmentsAS.enchantmentScorchingHeat, 1, 1)), Arrays.asList(new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76426_n, 0, 0)));
        ConstellationMapEffectRegistry.registerMapEffect(Constellations.pelotrio, Arrays.asList(new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185312_x, 1, 1), new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_151369_A, 4, 6)), Arrays.asList(new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76428_l, 2, 4), new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76444_x, 1, 4)));
        ConstellationMapEffectRegistry.registerMapEffect(Constellations.gelu, Arrays.asList(new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185301_j), new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_180309_e), new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185307_s, 2, 4)), Arrays.asList(new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76429_m, 1, 2), new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76426_n, 0, 0), new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76421_d, 0, 1)));
        ConstellationMapEffectRegistry.registerMapEffect(Constellations.ulteria, Arrays.asList(new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185307_s, 2, 3).setIgnoreCompatibility(), new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_77329_d, 4, 6).setIgnoreCompatibility(), new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185297_d, 4, 6).setIgnoreCompatibility(), new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_180308_g, 4, 6).setIgnoreCompatibility()), Arrays.asList(new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76444_x, 0, 2), new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76428_l, 1, 1), new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76437_t, 1, 2)));
        ConstellationMapEffectRegistry.registerMapEffect(Constellations.alcara, Arrays.asList(new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_191530_r, 3, 7), new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_151369_A, 2, 5).setIgnoreCompatibility(), new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_151370_z, 3, 6).setIgnoreCompatibility(), new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185306_r, 1, 1)), Arrays.asList(new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_188425_z, 2, 4), new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76441_p, 0, 1), new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76438_s, 1, 2)));
        ConstellationMapEffectRegistry.registerMapEffect(Constellations.vorux, Arrays.asList(new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185303_l, 4, 7).setIgnoreCompatibility(), new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_180312_n, 4, 7).setIgnoreCompatibility(), new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185302_k, 3, 4).setIgnoreCompatibility(), new ConstellationMapEffectRegistry.EnchantmentMapEffect(Enchantments.field_185309_u, 3, 4).setIgnoreCompatibility()), Arrays.asList(new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76420_g, 2, 3), new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76429_m, 0, 1), new ConstellationMapEffectRegistry.PotionMapEffect(MobEffects.field_76419_f, 1, 3)));
    }

    private static void registerConstellations() {
        ConstellationRegistry.registerConstellation(Constellations.discidia);
        ConstellationRegistry.registerConstellation(Constellations.armara);
        ConstellationRegistry.registerConstellation(Constellations.vicio);
        ConstellationRegistry.registerConstellation(Constellations.aevitas);
        ConstellationRegistry.registerConstellation(Constellations.evorsio);
        ConstellationRegistry.registerConstellation(Constellations.lucerna);
        ConstellationRegistry.registerConstellation(Constellations.mineralis);
        ConstellationRegistry.registerConstellation(Constellations.horologium);
        ConstellationRegistry.registerConstellation(Constellations.octans);
        ConstellationRegistry.registerConstellation(Constellations.bootes);
        ConstellationRegistry.registerConstellation(Constellations.fornax);
        ConstellationRegistry.registerConstellation(Constellations.pelotrio);
        ConstellationRegistry.registerConstellation(Constellations.gelu);
        ConstellationRegistry.registerConstellation(Constellations.ulteria);
        ConstellationRegistry.registerConstellation(Constellations.alcara);
        ConstellationRegistry.registerConstellation(Constellations.vorux);
    }

    private static void registerSignatureItems() {
        Constellations.discidia.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151145_ak)));
        Constellations.discidia.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_IRON_INGOT));
        Constellations.discidia.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151032_g)));
        Constellations.discidia.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_REDSTONE_DUST));
        Constellations.armara.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_IRON_INGOT));
        Constellations.armara.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_LEATHER));
        Constellations.armara.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151119_aD)));
        Constellations.armara.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_GLOWSTONE_DUST));
        Constellations.vicio.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_FEATHER));
        Constellations.vicio.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151102_aT)));
        Constellations.vicio.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151007_F)));
        Constellations.vicio.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151115_aP)));
        Constellations.aevitas.addSignatureItem(new ItemHandle(OreDictAlias.BLOCK_SAPLING));
        Constellations.aevitas.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_STARMETAL_DUST));
        Constellations.aevitas.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151014_N)));
        Constellations.aevitas.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_SUGAR_CANE));
        Constellations.evorsio.addSignatureItem(new ItemHandle(OreDictAlias.BLOCK_COBBLESTONE));
        Constellations.evorsio.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151145_ak)));
        Constellations.evorsio.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_GUNPOWDER));
        Constellations.evorsio.addSignatureItem(new ItemHandle(new ItemStack(Blocks.field_150335_W)));
        Constellations.lucerna.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_GLOWSTONE_DUST));
        Constellations.lucerna.addSignatureItem(new ItemHandle(new ItemStack(Blocks.field_150478_aa)));
        Constellations.lucerna.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_REDSTONE_DUST));
        Constellations.lucerna.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151044_h)));
        Constellations.mineralis.addSignatureItem(new ItemHandle(OreDictAlias.BLOCK_IRON_ORE));
        Constellations.mineralis.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_GOLD_INGOT));
        Constellations.mineralis.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_IRON_INGOT));
        Constellations.mineralis.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_REDSTONE_DUST));
        Constellations.horologium.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_STARMETAL_DUST));
        Constellations.horologium.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_DIAMOND));
        Constellations.horologium.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_ENDERPEARL));
        Constellations.horologium.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151113_aN)));
        Constellations.octans.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151115_aP)));
        Constellations.octans.addSignatureItem(new ItemHandle(new ItemStack((Item)Items.field_151112_aM)));
        Constellations.octans.addSignatureItem(new ItemHandle(OreDictAlias.getDyeOreDict(EnumDyeColor.BLUE)));
        Constellations.octans.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151119_aD)));
        Constellations.bootes.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_WHEAT));
        Constellations.bootes.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_BONE));
        Constellations.bootes.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151034_e)));
        Constellations.bootes.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_LEATHER));
        Constellations.fornax.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151044_h)));
        Constellations.fornax.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_REDSTONE_DUST));
        Constellations.fornax.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_IRON_INGOT));
        Constellations.fornax.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_GUNPOWDER));
        Constellations.pelotrio.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151078_bh)));
        Constellations.pelotrio.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151065_br)));
        Constellations.pelotrio.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151034_e)));
        Constellations.pelotrio.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_EGG));
        Constellations.gelu.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151126_ay)));
        Constellations.gelu.addSignatureItem(new ItemHandle(new ItemStack(Blocks.field_150432_aD)));
        Constellations.gelu.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_NETHER_QUARTZ));
        Constellations.gelu.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151008_G)));
        Constellations.ulteria.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_STARMETAL_INGOT));
        Constellations.ulteria.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151116_aA)));
        Constellations.ulteria.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151045_i)));
        Constellations.ulteria.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151072_bj)));
        Constellations.alcara.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151075_bm)));
        Constellations.alcara.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151079_bi)));
        Constellations.alcara.addSignatureItem(new ItemHandle(new ItemStack(Blocks.field_150425_aM)));
        Constellations.alcara.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151044_h)));
        Constellations.vorux.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151065_br)));
        Constellations.vorux.addSignatureItem(new ItemHandle(ItemUsableDust.DustType.NOCTURNAL.asStack()));
        Constellations.vorux.addSignatureItem(new ItemHandle(OreDictAlias.ITEM_GUNPOWDER));
        Constellations.vorux.addSignatureItem(new ItemHandle(new ItemStack(Items.field_151130_bT)));
    }

    private static void buildConstellations() {
        Constellations.discidia = new ConstellationBase.Major("discidia", new Color(14686467));
        StarLocation sl1 = Constellations.discidia.addStar(7, 2);
        StarLocation sl2 = Constellations.discidia.addStar(3, 6);
        StarLocation sl3 = Constellations.discidia.addStar(5, 12);
        StarLocation sl4 = Constellations.discidia.addStar(20, 11);
        StarLocation sl5 = Constellations.discidia.addStar(15, 17);
        StarLocation sl6 = Constellations.discidia.addStar(26, 21);
        StarLocation sl7 = Constellations.discidia.addStar(23, 27);
        StarLocation sl8 = Constellations.discidia.addStar(15, 25);
        Constellations.discidia.addConnection(sl1, sl2);
        Constellations.discidia.addConnection(sl2, sl3);
        Constellations.discidia.addConnection(sl2, sl4);
        Constellations.discidia.addConnection(sl4, sl5);
        Constellations.discidia.addConnection(sl5, sl7);
        Constellations.discidia.addConnection(sl6, sl7);
        Constellations.discidia.addConnection(sl7, sl8);
        Constellations.armara = new ConstellationBase.Major("armara", new Color(0xB7BBB8));
        sl1 = Constellations.armara.addStar(8, 4);
        sl2 = Constellations.armara.addStar(9, 15);
        sl3 = Constellations.armara.addStar(11, 26);
        sl4 = Constellations.armara.addStar(19, 25);
        sl5 = Constellations.armara.addStar(23, 14);
        sl6 = Constellations.armara.addStar(23, 4);
        sl7 = Constellations.armara.addStar(15, 7);
        Constellations.armara.addConnection(sl1, sl2);
        Constellations.armara.addConnection(sl2, sl3);
        Constellations.armara.addConnection(sl3, sl4);
        Constellations.armara.addConnection(sl4, sl5);
        Constellations.armara.addConnection(sl5, sl6);
        Constellations.armara.addConnection(sl6, sl7);
        Constellations.armara.addConnection(sl7, sl1);
        Constellations.armara.addConnection(sl2, sl5);
        Constellations.armara.addConnection(sl2, sl7);
        Constellations.armara.addConnection(sl5, sl7);
        Constellations.vicio = new ConstellationBase.Major("vicio", new Color(48557));
        sl1 = Constellations.vicio.addStar(3, 8);
        sl2 = Constellations.vicio.addStar(13, 9);
        sl3 = Constellations.vicio.addStar(6, 23);
        sl4 = Constellations.vicio.addStar(14, 16);
        sl5 = Constellations.vicio.addStar(23, 24);
        sl6 = Constellations.vicio.addStar(22, 16);
        sl7 = Constellations.vicio.addStar(24, 4);
        Constellations.vicio.addConnection(sl1, sl2);
        Constellations.vicio.addConnection(sl2, sl7);
        Constellations.vicio.addConnection(sl3, sl4);
        Constellations.vicio.addConnection(sl4, sl7);
        Constellations.vicio.addConnection(sl5, sl6);
        Constellations.vicio.addConnection(sl6, sl7);
        Constellations.aevitas = new ConstellationBase.Major("aevitas", new Color(3073024));
        sl1 = Constellations.aevitas.addStar(15, 14);
        sl2 = Constellations.aevitas.addStar(7, 12);
        sl3 = Constellations.aevitas.addStar(3, 6);
        sl4 = Constellations.aevitas.addStar(21, 8);
        sl5 = Constellations.aevitas.addStar(25, 2);
        sl6 = Constellations.aevitas.addStar(13, 21);
        sl7 = Constellations.aevitas.addStar(9, 26);
        sl8 = Constellations.aevitas.addStar(17, 28);
        StarLocation sl9 = Constellations.aevitas.addStar(27, 17);
        Constellations.aevitas.addConnection(sl1, sl2);
        Constellations.aevitas.addConnection(sl2, sl3);
        Constellations.aevitas.addConnection(sl1, sl4);
        Constellations.aevitas.addConnection(sl4, sl5);
        Constellations.aevitas.addConnection(sl1, sl6);
        Constellations.aevitas.addConnection(sl6, sl7);
        Constellations.aevitas.addConnection(sl6, sl8);
        Constellations.aevitas.addConnection(sl4, sl9);
        Constellations.evorsio = new ConstellationBase.Major("evorsio", new Color(0xA00100));
        sl1 = Constellations.evorsio.addStar(13, 16);
        sl2 = Constellations.evorsio.addStar(18, 6);
        sl3 = Constellations.evorsio.addStar(26, 4);
        sl4 = Constellations.evorsio.addStar(24, 13);
        sl5 = Constellations.evorsio.addStar(2, 18);
        sl6 = Constellations.evorsio.addStar(4, 27);
        sl7 = Constellations.evorsio.addStar(11, 24);
        Constellations.evorsio.addConnection(sl1, sl2);
        Constellations.evorsio.addConnection(sl1, sl3);
        Constellations.evorsio.addConnection(sl1, sl4);
        Constellations.evorsio.addConnection(sl1, sl5);
        Constellations.evorsio.addConnection(sl1, sl6);
        Constellations.evorsio.addConnection(sl1, sl7);
        Constellations.lucerna = new ConstellationBase.Weak("lucerna", new Color(16770825));
        sl1 = Constellations.lucerna.addStar(15, 13);
        sl2 = Constellations.lucerna.addStar(3, 5);
        sl3 = Constellations.lucerna.addStar(25, 3);
        sl4 = Constellations.lucerna.addStar(28, 16);
        sl5 = Constellations.lucerna.addStar(22, 27);
        sl6 = Constellations.lucerna.addStar(6, 26);
        Constellations.lucerna.addConnection(sl1, sl2);
        Constellations.lucerna.addConnection(sl1, sl3);
        Constellations.lucerna.addConnection(sl1, sl4);
        Constellations.lucerna.addConnection(sl1, sl5);
        Constellations.lucerna.addConnection(sl1, sl6);
        Constellations.mineralis = new ConstellationBase.Weak("mineralis", new Color(13335818));
        sl1 = Constellations.mineralis.addStar(16, 2);
        sl2 = Constellations.mineralis.addStar(8, 8);
        sl3 = Constellations.mineralis.addStar(9, 22);
        sl4 = Constellations.mineralis.addStar(15, 29);
        sl5 = Constellations.mineralis.addStar(23, 21);
        sl6 = Constellations.mineralis.addStar(24, 9);
        Constellations.mineralis.addConnection(sl1, sl2);
        Constellations.mineralis.addConnection(sl2, sl3);
        Constellations.mineralis.addConnection(sl3, sl4);
        Constellations.mineralis.addConnection(sl4, sl5);
        Constellations.mineralis.addConnection(sl5, sl6);
        Constellations.mineralis.addConnection(sl6, sl1);
        Constellations.mineralis.addConnection(sl1, sl4);
        Constellations.horologium = new ConstellationBase.WeakSpecial("horologium", new Color(8197812)){

            @Override
            public boolean doesShowUp(WorldSkyHandler handle, World world, long day) {
                long rSeed;
                if (world.field_72995_K) {
                    Optional<Long> testSeed = ConstellationSkyHandler.getInstance().getSeedIfPresent(world);
                    if (!testSeed.isPresent()) {
                        return false;
                    }
                    rSeed = testSeed.get();
                } else {
                    rSeed = new Random(world.func_72905_C()).nextLong();
                }
                return this.isDayOfSolarEclipse(rSeed, day);
            }

            @Override
            public float getDistribution(WorldSkyHandler handle, World world, long day, boolean showsUp) {
                return showsUp ? 1.0f : 0.6f;
            }
        };
        sl1 = Constellations.horologium.addStar(7, 6);
        sl2 = Constellations.horologium.addStar(22, 5);
        sl3 = Constellations.horologium.addStar(5, 27);
        sl4 = Constellations.horologium.addStar(23, 25);
        Constellations.horologium.addConnection(sl1, sl2);
        Constellations.horologium.addConnection(sl2, sl3);
        Constellations.horologium.addConnection(sl3, sl4);
        Constellations.horologium.addConnection(sl4, sl1);
        Constellations.octans = new ConstellationBase.Weak("octans", new Color(7368447));
        sl1 = Constellations.octans.addStar(3, 6);
        sl2 = Constellations.octans.addStar(11, 11);
        sl3 = Constellations.octans.addStar(18, 4);
        sl4 = Constellations.octans.addStar(18, 29);
        Constellations.octans.addConnection(sl1, sl2);
        Constellations.octans.addConnection(sl2, sl3);
        Constellations.octans.addConnection(sl3, sl4);
        Constellations.octans.addConnection(sl2, sl4);
        Constellations.bootes = new ConstellationBase.Weak("bootes", new Color(13901014));
        sl1 = Constellations.bootes.addStar(9, 22);
        sl2 = Constellations.bootes.addStar(3, 14);
        sl3 = Constellations.bootes.addStar(22, 27);
        sl4 = Constellations.bootes.addStar(16, 5);
        sl5 = Constellations.bootes.addStar(26, 3);
        sl6 = Constellations.bootes.addStar(24, 11);
        Constellations.bootes.addConnection(sl1, sl2);
        Constellations.bootes.addConnection(sl1, sl3);
        Constellations.bootes.addConnection(sl1, sl4);
        Constellations.bootes.addConnection(sl1, sl6);
        Constellations.bootes.addConnection(sl4, sl5);
        Constellations.bootes.addConnection(sl5, sl6);
        Constellations.fornax = new ConstellationBase.Weak("fornax", new Color(16731675));
        sl1 = Constellations.fornax.addStar(4, 25);
        sl2 = Constellations.fornax.addStar(14, 28);
        sl3 = Constellations.fornax.addStar(28, 21);
        sl4 = Constellations.fornax.addStar(12, 18);
        sl5 = Constellations.fornax.addStar(16, 16);
        Constellations.fornax.addConnection(sl1, sl2);
        Constellations.fornax.addConnection(sl2, sl3);
        Constellations.fornax.addConnection(sl2, sl4);
        Constellations.fornax.addConnection(sl2, sl5);
        Constellations.pelotrio = new ConstellationBase.WeakSpecial("pelotrio", new Color(15466603)){

            @Override
            public boolean doesShowUp(WorldSkyHandler handle, World world, long day) {
                return handle.getCurrentMoonPhase() == MoonPhase.NEW || handle.getCurrentMoonPhase() == MoonPhase.FULL;
            }

            @Override
            public float getDistribution(WorldSkyHandler handle, World world, long day, boolean showingUp) {
                if (showingUp) {
                    return 1.0f;
                }
                MoonPhase current = handle.getCurrentMoonPhase();
                if (current == MoonPhase.WANING1_2 || current == MoonPhase.WAXING1_2) {
                    return 0.5f;
                }
                return 0.75f;
            }
        };
        sl1 = Constellations.pelotrio.addStar(4, 7);
        sl2 = Constellations.pelotrio.addStar(12, 2);
        sl3 = Constellations.pelotrio.addStar(20, 3);
        sl4 = Constellations.pelotrio.addStar(15, 13);
        sl5 = Constellations.pelotrio.addStar(10, 23);
        sl6 = Constellations.pelotrio.addStar(26, 11);
        Constellations.pelotrio.addConnection(sl1, sl2);
        Constellations.pelotrio.addConnection(sl2, sl4);
        Constellations.pelotrio.addConnection(sl3, sl4);
        Constellations.pelotrio.addConnection(sl4, sl5);
        Constellations.pelotrio.addConnection(sl4, sl6);
        Constellations.pelotrio.addConnection(sl6, sl3);
        Constellations.gelu = new ConstellationBase.Minor("gelu", new Color(7703464), MoonPhase.NEW, MoonPhase.WAXING1_4, MoonPhase.WAXING1_2);
        sl1 = Constellations.gelu.addStar(8, 7);
        sl2 = Constellations.gelu.addStar(28, 8);
        sl3 = Constellations.gelu.addStar(23, 21);
        sl4 = Constellations.gelu.addStar(3, 22);
        sl5 = Constellations.gelu.addStar(17, 17);
        sl6 = Constellations.gelu.addStar(16, 13);
        Constellations.gelu.addConnection(sl1, sl2);
        Constellations.gelu.addConnection(sl3, sl4);
        Constellations.gelu.addConnection(sl2, sl5);
        Constellations.gelu.addConnection(sl4, sl6);
        Constellations.ulteria = new ConstellationBase.Minor("ulteria", new Color(3437667), MoonPhase.WANING1_2, MoonPhase.WANING3_4, MoonPhase.NEW);
        sl1 = Constellations.ulteria.addStar(14, 9);
        sl2 = Constellations.ulteria.addStar(17, 16);
        sl3 = Constellations.ulteria.addStar(25, 19);
        sl4 = Constellations.ulteria.addStar(7, 21);
        sl5 = Constellations.ulteria.addStar(22, 25);
        Constellations.ulteria.addConnection(sl1, sl2);
        Constellations.ulteria.addConnection(sl2, sl3);
        Constellations.ulteria.addConnection(sl4, sl5);
        Constellations.alcara = new ConstellationBase.Minor("alcara", new Color(8399186), MoonPhase.WANING1_2, MoonPhase.WAXING1_2);
        sl1 = Constellations.alcara.addStar(6, 27);
        sl2 = Constellations.alcara.addStar(14, 20);
        sl3 = Constellations.alcara.addStar(17, 24);
        sl4 = Constellations.alcara.addStar(10, 18);
        sl5 = Constellations.alcara.addStar(7, 5);
        sl6 = Constellations.alcara.addStar(17, 9);
        Constellations.alcara.addConnection(sl1, sl2);
        Constellations.alcara.addConnection(sl2, sl3);
        Constellations.alcara.addConnection(sl1, sl4);
        Constellations.alcara.addConnection(sl4, sl5);
        Constellations.alcara.addConnection(sl4, sl6);
        Constellations.vorux = new ConstellationBase.Minor("vorux", new Color(11044894), MoonPhase.FULL, MoonPhase.WAXING3_4, MoonPhase.WANING3_4);
        sl1 = Constellations.vorux.addStar(3, 21);
        sl2 = Constellations.vorux.addStar(7, 7);
        sl3 = Constellations.vorux.addStar(14, 15);
        sl4 = Constellations.vorux.addStar(18, 5);
        sl5 = Constellations.vorux.addStar(25, 16);
        sl6 = Constellations.vorux.addStar(16, 26);
        sl7 = Constellations.vorux.addStar(27, 2);
        Constellations.vorux.addConnection(sl1, sl2);
        Constellations.vorux.addConnection(sl2, sl3);
        Constellations.vorux.addConnection(sl3, sl4);
        Constellations.vorux.addConnection(sl4, sl5);
        Constellations.vorux.addConnection(sl5, sl6);
        Constellations.vorux.addConnection(sl4, sl7);
    }
}

