/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.tool;

import hellfirepvp.astralsorcery.common.entities.EntityCrystalTool;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalPropertyItem;
import hellfirepvp.astralsorcery.common.item.crystal.ToolCrystalProperties;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemCrystalToolBase
extends ItemTool
implements CrystalPropertyItem {
    private static final Random rand = new Random();
    private final int crystalCount;

    public ItemCrystalToolBase(int crystalCount) {
        super(0.0f, 0.0f, RegistryItems.crystalToolMaterial, Collections.emptySet());
        this.func_77656_e(0);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
        this.crystalCount = crystalCount;
    }

    public void setDamageVsEntity(float damageVsEntity) {
        this.field_77865_bY = damageVsEntity;
    }

    public void setAttackSpeed(float attackSpeed) {
        this.field_185065_c = attackSpeed;
    }

    public int getCrystalCount() {
        return this.crystalCount;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ToolCrystalProperties prop = ItemCrystalToolBase.getToolProperties(stack);
        CrystalProperties.addPropertyTooltip(prop, tooltip, this.getMaxSize(stack));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public int getMaxSize(ItemStack stack) {
        return 900 * this.getCrystalCount();
    }

    @Override
    @Nullable
    public CrystalProperties provideCurrentPropertiesOrNull(ItemStack stack) {
        return ItemCrystalToolBase.getToolProperties(stack);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        float str = super.func_150893_a(stack, state);
        ToolCrystalProperties properties = ItemCrystalToolBase.getToolProperties(stack);
        return str * properties.getEfficiencyMultiplier() * 2.0f;
    }

    public static ToolCrystalProperties getToolProperties(ItemStack stack) {
        NBTTagCompound nbt = NBTHelper.getPersistentData(stack);
        return ToolCrystalProperties.readFromNBT(nbt);
    }

    public static void setToolProperties(ItemStack stack, ToolCrystalProperties properties) {
        NBTTagCompound nbt = NBTHelper.getPersistentData(stack);
        properties.writeToNBT(nbt);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(World world, Entity ei, ItemStack itemstack) {
        EntityCrystalTool newItem = new EntityCrystalTool(ei.field_70170_p, ei.field_70165_t, ei.field_70163_u, ei.field_70161_v, itemstack);
        newItem.field_70159_w = ei.field_70159_w;
        newItem.field_70181_x = ei.field_70181_x;
        newItem.field_70179_y = ei.field_70179_y;
        newItem.func_174869_p();
        if (ei instanceof EntityItem) {
            newItem.func_145799_b(((EntityItem)ei).func_145800_j());
            newItem.func_145797_a(((EntityItem)ei).func_145798_i());
        }
        return newItem;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
        this.damageProperties(stack, damage);
    }

    private void damageProperties(ItemStack stack, int damage) {
        ToolCrystalProperties prop = ItemCrystalToolBase.getToolProperties(stack);
        if (prop == null) {
            stack.func_77964_b(stack.func_77958_k());
            return;
        }
        if (prop.getSize() <= 0) {
            super.setDamage(stack, 11);
            return;
        }
        if (damage < 0) {
            return;
        }
        for (int i = 0; i < damage; ++i) {
            double purity;
            double chance = Math.pow((double)prop.getCollectiveCapability() / 100.0, 2.0);
            if (!(chance >= (double)rand.nextFloat())) continue;
            if (rand.nextInt(8) == 0) {
                prop = prop.copyDamagedCutting();
            }
            if (!((purity = (double)prop.getPurity() / 100.0) <= (double)rand.nextFloat()) || rand.nextInt(8) != 0) continue;
            prop = prop.copyDamagedCutting();
        }
        ItemCrystalToolBase.setToolProperties(stack, prop);
    }

    public int getMaxDamage(ItemStack stack) {
        return 10;
    }
}

