/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.entities;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.cape.impl.CapeEffectPelotrio;
import hellfirepvp.astralsorcery.common.entities.EntityTechnicalAmbient;
import hellfirepvp.astralsorcery.common.util.DamageUtil;
import hellfirepvp.astralsorcery.common.util.EntityUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityFlyHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySpectralTool
extends EntityFlying
implements EntityTechnicalAmbient {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(EntitySpectralTool.class, (DataSerializer)DataSerializers.field_187196_f);
    private AIToolTask aiTask;
    private int ticksUntilDeath = 0;

    public EntitySpectralTool(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 0.8f);
        this.field_70765_h = new EntityFlyHelper((EntityLiving)this);
    }

    public EntitySpectralTool(World world, BlockPos spawnPos, ItemStack tool, ToolTask task) {
        super(world);
        this.func_70105_a(0.6f, 0.8f);
        this.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 0.5);
        this.setItem(tool);
        this.aiTask.taskTarget = task;
        this.ticksUntilDeath = 100 + this.field_70146_Z.nextInt(40);
        this.field_70765_h = new EntityFlyHelper((EntityLiving)this);
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.5);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.aiTask = new AIToolTask(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiTask);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.spawnAmbientEffects();
        } else {
            --this.ticksUntilDeath;
            if (this.ticksUntilDeath <= 0) {
                DamageUtil.attackEntityFrom((Entity)this, CommonProxy.dmgSourceStellar, 5000.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnAmbientEffects() {
        if (this.field_70146_Z.nextFloat() < 0.2f) {
            Color c = IConstellation.weak;
            double x = this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)(this.field_70130_N / 2.0f);
            double y = this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * (this.field_70131_O / 2.0f)) + 0.2;
            double z = this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)(this.field_70130_N / 2.0f);
            EntityFXFacingParticle p = EffectHelper.genericFlareParticle(x, y, z);
            p.setColor(c).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
            p.scale(this.field_70146_Z.nextFloat() * 0.5f + 0.3f);
            p.setMaxAge(30 + this.field_70146_Z.nextInt(20));
            if (this.field_70146_Z.nextFloat() < 0.8f) {
                p = EffectHelper.genericFlareParticle(x, y, z);
                p.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
                p.scale(this.field_70146_Z.nextFloat() * 0.2f + 0.1f);
                p.setMaxAge(20 + this.field_70146_Z.nextInt(10));
            }
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    private void setItem(ItemStack tool) {
        this.field_70180_af.func_187227_b(ITEM, (Object)tool);
    }

    public ItemStack getItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(ITEM);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setItem(NBTHelper.getStack(compound, "AS_SpectralItem", ItemStack.field_190927_a));
        int task = compound.func_74762_e("AS_ToolTask");
        if (this.aiTask != null) {
            this.aiTask.taskTarget = new ToolTask(ToolTask.Type.values()[MathHelper.func_76125_a((int)task, (int)0, (int)(ToolTask.Type.values().length - 1))]);
        } else {
            this.aiTask = new AIToolTask(this);
            this.aiTask.taskTarget = new ToolTask(ToolTask.Type.BREAK_BLOCK);
        }
        this.ticksUntilDeath = compound.func_74762_e("AS_ToolDeathTicks");
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTHelper.setStack(compound, "AS_SpectralItem", this.getItem());
        int task = 0;
        if (this.aiTask != null) {
            task = this.aiTask.taskTarget.type.ordinal();
        }
        compound.func_74768_a("AS_ToolTask", task);
        compound.func_74768_a("AS_ToolDeathTicks", this.ticksUntilDeath);
    }

    private static class AIToolTask
    extends EntityAIBase {
        private final EntitySpectralTool parentEntity;
        private ToolTask taskTarget = null;
        private BlockPos designatedBreakTarget = null;
        private EntityLivingBase designatedAttackTarget = null;
        private int actionTicks = 0;

        public AIToolTask(EntitySpectralTool entity) {
            this.parentEntity = entity;
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            switch (this.taskTarget.type) {
                case BREAK_BLOCK: {
                    BlockPos validStateStone = MiscUtils.searchAreaForFirst(this.parentEntity.field_70170_p, this.parentEntity.func_180425_c(), 8, Vector3.atEntityCorner((Entity)this.parentEntity), (world, at, state) -> world.func_175625_s(at) == null && !state.func_177230_c().isAir(state, (IBlockAccess)world, at) && state.func_185887_b(world, at) != -1.0f && state.func_185887_b(world, at) <= 10.0f && MiscUtils.canToolBreakBlockWithoutPlayer(world, at, state, new ItemStack(Items.field_151046_w)));
                    return validStateStone != null;
                }
                case BREAK_LOG: {
                    BlockPos validStateLog = MiscUtils.searchAreaForFirst(this.parentEntity.field_70170_p, this.parentEntity.func_180425_c(), 10, Vector3.atEntityCorner((Entity)this.parentEntity), (world, at, state) -> world.func_175625_s(at) == null && !state.func_177230_c().isAir(state, (IBlockAccess)world, at) && (state.func_177230_c().isWood((IBlockAccess)world, at) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, at)) && state.func_185887_b(world, at) != -1.0f && state.func_185887_b(world, at) <= 10.0f && MiscUtils.canToolBreakBlockWithoutPlayer(world, at, state, new ItemStack(Items.field_151056_x)));
                    return validStateLog != null;
                }
                case ATTACK_MONSTER: {
                    List eList = this.parentEntity.field_70170_p.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(-8.0, -8.0, -8.0, 8.0, 8.0, 8.0).func_186670_a(this.parentEntity.func_180425_c()), e -> e != null && !e.field_70128_L && e.isCreatureType(EnumCreatureType.MONSTER, false));
                    EntityLivingBase entity = EntityUtils.selectClosest(eList, e -> e.func_70068_e((Entity)this.parentEntity));
                    return entity != null;
                }
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.designatedAttackTarget != null || this.designatedBreakTarget != null;
        }

        public void func_75251_c() {
            super.func_75251_c();
            this.designatedBreakTarget = null;
            this.designatedAttackTarget = null;
            this.actionTicks = 0;
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (!this.func_75253_b()) {
                return;
            }
            if (this.actionTicks < 0) {
                this.actionTicks = 0;
            }
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            boolean resetTimer = false;
            switch (this.taskTarget.type) {
                case BREAK_BLOCK: {
                    if (this.parentEntity.field_70170_p.func_175623_d(this.designatedBreakTarget)) {
                        this.designatedBreakTarget = null;
                        resetTimer = true;
                        break;
                    }
                    double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
                    double d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u;
                    double d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v;
                    double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                    this.parentEntity.func_70605_aq().func_75642_a((double)this.designatedBreakTarget.func_177958_n(), (double)this.designatedBreakTarget.func_177956_o(), (double)this.designatedBreakTarget.func_177952_p(), 1.5);
                    if (!(d3 < 3.0)) break;
                    ++this.actionTicks;
                    if (this.actionTicks <= CapeEffectPelotrio.getTicksBreakBlockPick() || !(this.parentEntity.field_70170_p instanceof WorldServer) || !MiscUtils.breakBlockWithoutPlayer((WorldServer)this.parentEntity.field_70170_p, this.designatedBreakTarget, this.parentEntity.field_70170_p.func_180495_p(this.designatedBreakTarget), true, true, true)) break;
                    resetTimer = true;
                    break;
                }
                case BREAK_LOG: {
                    if (this.parentEntity.field_70170_p.func_175623_d(this.designatedBreakTarget)) {
                        this.designatedBreakTarget = null;
                        resetTimer = true;
                        break;
                    }
                    double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
                    double d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u;
                    double d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v;
                    double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                    this.parentEntity.func_70605_aq().func_75642_a((double)this.designatedBreakTarget.func_177958_n(), (double)this.designatedBreakTarget.func_177956_o(), (double)this.designatedBreakTarget.func_177952_p(), 1.5);
                    if (!(d3 < 3.0)) break;
                    ++this.actionTicks;
                    if (this.actionTicks <= CapeEffectPelotrio.getTicksBreakBlockAxe() || !(this.parentEntity.field_70170_p instanceof WorldServer) || !MiscUtils.breakBlockWithoutPlayer((WorldServer)this.parentEntity.field_70170_p, this.designatedBreakTarget, this.parentEntity.field_70170_p.func_180495_p(this.designatedBreakTarget), true, true, true)) break;
                    resetTimer = true;
                    break;
                }
                case ATTACK_MONSTER: {
                    double d2;
                    double d1;
                    double d0;
                    if (this.designatedAttackTarget.field_70128_L) {
                        this.designatedAttackTarget = null;
                        resetTimer = true;
                        break;
                    }
                    List eList = this.parentEntity.field_70170_p.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(-8.0, -8.0, -8.0, 8.0, 8.0, 8.0).func_186670_a(this.parentEntity.func_180425_c()), e -> e != null && !e.field_70128_L && e.isCreatureType(EnumCreatureType.MONSTER, false));
                    EntityLivingBase entity = EntityUtils.selectClosest(eList, e -> e.func_70068_e((Entity)this.parentEntity));
                    if (entity != null) {
                        d0 = entity.field_70165_t;
                        d1 = entity.field_70163_u;
                        d2 = entity.field_70161_v;
                        this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.6);
                    }
                    d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
                    d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u;
                    d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v;
                    double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                    this.parentEntity.func_70605_aq().func_75642_a(this.designatedAttackTarget.field_70165_t, this.designatedAttackTarget.field_70163_u, this.designatedAttackTarget.field_70161_v, 1.7);
                    if (!(d3 < 3.0)) break;
                    ++this.actionTicks;
                    if (this.actionTicks <= CapeEffectPelotrio.getTicksSwordAttacks()) break;
                    DamageUtil.attackEntityFrom((Entity)this.designatedAttackTarget, CommonProxy.dmgSourceStellar, CapeEffectPelotrio.getSwordAttackDamage());
                    resetTimer = true;
                }
            }
            if (resetTimer) {
                this.actionTicks = 0;
            }
        }

        public void func_75249_e() {
            switch (this.taskTarget.type) {
                case BREAK_BLOCK: {
                    BlockPos validStateStone = MiscUtils.searchAreaForFirst(this.parentEntity.field_70170_p, this.parentEntity.func_180425_c(), 8, Vector3.atEntityCorner((Entity)this.parentEntity), (world, at, state) -> world.func_175625_s(at) == null && !state.func_177230_c().isAir(state, (IBlockAccess)world, at) && state.func_185887_b(world, at) != -1.0f && state.func_185887_b(world, at) <= 10.0f && MiscUtils.canToolBreakBlockWithoutPlayer(world, at, state, new ItemStack(Items.field_151046_w)));
                    if (validStateStone == null) break;
                    this.designatedBreakTarget = validStateStone;
                    double d0 = validStateStone.func_177958_n();
                    double d1 = validStateStone.func_177956_o();
                    double d2 = validStateStone.func_177952_p();
                    this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.5);
                    break;
                }
                case BREAK_LOG: {
                    BlockPos validStateLog = MiscUtils.searchAreaForFirst(this.parentEntity.field_70170_p, this.parentEntity.func_180425_c(), 10, Vector3.atEntityCorner((Entity)this.parentEntity), (world, at, state) -> world.func_175625_s(at) == null && !state.func_177230_c().isAir(state, (IBlockAccess)world, at) && (state.func_177230_c().isWood((IBlockAccess)world, at) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, at)) && state.func_185887_b(world, at) != -1.0f && state.func_185887_b(world, at) <= 10.0f && MiscUtils.canToolBreakBlockWithoutPlayer(world, at, state, new ItemStack(Items.field_151056_x)));
                    if (validStateLog == null) break;
                    this.designatedBreakTarget = validStateLog;
                    double d0 = validStateLog.func_177958_n();
                    double d1 = validStateLog.func_177956_o();
                    double d2 = validStateLog.func_177952_p();
                    this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.5);
                    break;
                }
                case ATTACK_MONSTER: {
                    List eList = this.parentEntity.field_70170_p.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(-8.0, -8.0, -8.0, 8.0, 8.0, 8.0).func_186670_a(this.parentEntity.func_180425_c()), e -> e != null && !e.field_70128_L && e.isCreatureType(EnumCreatureType.MONSTER, false));
                    EntityLivingBase entity = EntityUtils.selectClosest(eList, e -> e.func_70068_e((Entity)this.parentEntity));
                    if (entity == null) break;
                    this.designatedAttackTarget = entity;
                    double d0 = entity.field_70165_t;
                    double d1 = entity.field_70163_u;
                    double d2 = entity.field_70161_v;
                    this.parentEntity.func_70605_aq().func_75642_a(d0, d1, d2, 1.7);
                }
            }
        }
    }

    public static class ToolTask {
        private final Type type;

        private ToolTask(Type type) {
            this.type = type;
        }

        public static ToolTask createPickaxeTask() {
            return new ToolTask(Type.BREAK_BLOCK);
        }

        public static ToolTask createLogTask() {
            return new ToolTask(Type.BREAK_LOG);
        }

        public static ToolTask createAttackTask() {
            return new ToolTask(Type.ATTACK_MONSTER);
        }

        private static enum Type {
            BREAK_BLOCK,
            BREAK_LOG,
            ATTACK_MONSTER;

        }
    }
}

