/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.world.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.world.CachedWorldData;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.structure.StructureMatcher;
import hellfirepvp.astralsorcery.common.structure.StructureMatcherRegistry;
import hellfirepvp.astralsorcery.common.structure.array.PatternBlockArray;
import hellfirepvp.astralsorcery.common.structure.change.ChangeSubscriber;
import hellfirepvp.astralsorcery.common.structure.match.StructureMatcherPatternArray;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class StructureMatchingBuffer
extends CachedWorldData {
    private Map<ChunkPos, List<ChangeSubscriber<?>>> subscribers = Maps.newHashMap();
    private Map<BlockPos, ChangeSubscriber<?>> requestSubscribers = Maps.newHashMap();

    public StructureMatchingBuffer() {
        super(WorldCacheManager.SaveKey.STRUCTURE_MATCH);
    }

    @Override
    public void updateTick(World world) {
    }

    @Nonnull
    public ChangeSubscriber<StructureMatcherPatternArray> observeAndInitializePattern(IBlockAccess world, BlockPos center, PatternBlockArray pattern) {
        StructureMatcherPatternArray match = new StructureMatcherPatternArray(pattern.getRegistryName());
        match.initialize(world, center);
        return this.observeArea(center, match);
    }

    @Nonnull
    public <T extends StructureMatcher> ChangeSubscriber<T> observeArea(BlockPos requester, T matcher) {
        StructureMatcher regMatcher = StructureMatcherRegistry.INSTANCE.provideNewMatcher(matcher.getRegistryName());
        if (regMatcher == null) {
            AstralSorcery.log.warn("Found unregistered structure matcher: " + matcher.getRegistryName().toString());
            AstralSorcery.log.warn("It will NOT persist! Register your matchers!");
        }
        ChangeSubscriber<T> subscriber = new ChangeSubscriber<T>(requester, matcher);
        this.requestSubscribers.put(requester, subscriber);
        for (ChunkPos pos : subscriber.getObservableChunks()) {
            this.subscribers.computeIfAbsent(pos, chPos -> Lists.newArrayList()).add(subscriber);
        }
        this.markDirty();
        return subscriber;
    }

    public boolean removeSubscriber(BlockPos pos) {
        if (this.requestSubscribers.remove(pos) != null) {
            ChunkPos chunk = new ChunkPos(pos);
            List chunkSubscribers = this.subscribers.computeIfAbsent(chunk, ch -> Lists.newArrayList());
            chunkSubscribers.clear();
            for (ChangeSubscriber<?> subscr : this.requestSubscribers.values()) {
                if (!subscr.getObservableChunks().contains(chunk)) continue;
                chunkSubscribers.add(subscr);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public ChangeSubscriber<?> getSubscriber(BlockPos pos) {
        return this.requestSubscribers.get(pos);
    }

    @Nonnull
    public List<ChangeSubscriber<?>> getSubscribers(ChunkPos pos) {
        return this.subscribers.getOrDefault(pos, Collections.emptyList());
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.subscribers.clear();
        this.requestSubscribers.clear();
        NBTTagList subscriberList = compound.func_150295_c("subscribers", 10);
        for (int i = 0; i < subscriberList.func_74745_c(); ++i) {
            NBTTagCompound subscriberTag = subscriberList.func_150305_b(i);
            BlockPos requester = NBTHelper.readBlockPosFromNBT(subscriberTag);
            ResourceLocation matchIdentifier = new ResourceLocation(subscriberTag.func_74779_i("identifier"));
            StructureMatcher match = StructureMatcherRegistry.INSTANCE.provideNewMatcher(matchIdentifier);
            if (match == null) {
                AstralSorcery.log.warn("[Astral Sorcery] Unknown StructureMatcher: " + matchIdentifier.toString() + "! Skipping...");
                continue;
            }
            ChangeSubscriber<StructureMatcher> subscriber = new ChangeSubscriber<StructureMatcher>(requester, match);
            subscriber.readFromNBT(subscriberTag.func_74775_l("matchData"));
            this.requestSubscribers.put(subscriber.getRequester(), subscriber);
            for (ChunkPos chPos : subscriber.getObservableChunks()) {
                this.subscribers.computeIfAbsent(chPos, pos -> Lists.newArrayList()).add(subscriber);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        NBTTagList subscriberList = new NBTTagList();
        for (ChangeSubscriber<?> sub : this.requestSubscribers.values()) {
            NBTTagCompound subscriber = new NBTTagCompound();
            NBTHelper.writeBlockPosToNBT(sub.getRequester(), subscriber);
            subscriber.func_74778_a("identifier", ((StructureMatcher)sub.getMatcher()).getRegistryName().toString());
            NBTTagCompound subscriberData = new NBTTagCompound();
            sub.writeToNBT(subscriberData);
            subscriber.func_74782_a("matchData", (NBTBase)subscriberData);
            subscriberList.func_74742_a((NBTBase)subscriber);
        }
        compound.func_74782_a("subscribers", (NBTBase)subscriberList);
    }
}

