/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.world.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.data.world.CachedWorldData;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.tile.storage.StorageNetwork;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class StorageNetworkBuffer
extends CachedWorldData {
    private static final Random rand = new Random();
    private Map<BlockPos, StorageNetwork> rawNetworks = Maps.newHashMap();
    private Map<ChunkPos, List<StorageNetwork>> availableNetworks = Maps.newHashMap();

    public StorageNetworkBuffer() {
        super(WorldCacheManager.SaveKey.STORAGE_BUFFER);
    }

    @Override
    public void updateTick(World world) {
    }

    @Nullable
    public StorageNetwork getNetwork(BlockPos masterPos) {
        return this.rawNetworks.get(masterPos);
    }

    public void rebuildAccessContext() {
        this.availableNetworks.clear();
        for (StorageNetwork network : this.rawNetworks.values()) {
            for (StorageNetwork.CoreArea core : network.getCores()) {
                AxisAlignedBB box = core.getRealBox();
                ChunkPos from = Vector3.getMin(box).toChunkPos();
                ChunkPos to = Vector3.getMax(box).toChunkPos();
                for (int chX = from.field_77276_a; chX <= to.field_77276_a; ++chX) {
                    for (int chZ = from.field_77275_b; chZ <= to.field_77275_b; ++chZ) {
                        this.availableNetworks.computeIfAbsent(new ChunkPos(chX, chZ), pos -> Lists.newArrayList()).add(network);
                    }
                }
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.rawNetworks.clear();
        NBTTagList networks = compound.func_150295_c("networks", 10);
        for (int i = 0; i < networks.func_74745_c(); ++i) {
            NBTTagCompound tag = networks.func_150305_b(i);
            StorageNetwork net = new StorageNetwork();
            net.readFromNBT(tag);
            if (net.getCores().isEmpty()) continue;
            StorageNetwork.CoreArea master = net.getMaster();
            if (master == null) {
                master = MiscUtils.getRandomEntry(net.getCores(), rand);
            }
            this.rawNetworks.put(master.getPos(), net);
        }
        this.rebuildAccessContext();
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        NBTTagList networks = new NBTTagList();
        for (StorageNetwork network : this.rawNetworks.values()) {
            NBTTagCompound tag = new NBTTagCompound();
            network.writeToNBT(tag);
            networks.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("networks", (NBTBase)networks);
    }
}

