/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.helper;

import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.helper.AbstractRecipeAccessor;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipeAdapater;
import hellfirepvp.astralsorcery.common.crafting.helper.BasePlainRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.RecipeHelper;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ShapelessRecipe
extends AbstractRecipeAccessor {
    private final NonNullList<ItemHandle> inputs;

    public ShapelessRecipe(@Nonnull ItemStack output, NonNullList<ItemHandle> inputs) {
        super(output);
        this.inputs = inputs;
    }

    @Override
    @Nullable
    public ItemHandle getExpectedStack(int row, int column) {
        int index = row * 3 + column;
        return index >= this.inputs.size() ? null : (ItemHandle)this.inputs.get(index);
    }

    @Override
    @Nullable
    public ItemHandle getExpectedStack(ShapedRecipeSlot slot) {
        int index = slot.rowMultipler * 3 + slot.columnMultiplier;
        return index >= this.inputs.size() ? null : (ItemHandle)this.inputs.get(index);
    }

    public static class Builder {
        private boolean registered = false;
        private final ResourceLocation entry;
        private final ItemStack output;
        private final NonNullList<ItemHandle> inputs = NonNullList.func_191196_a();

        private Builder(String name, ItemStack output) {
            this.entry = new ResourceLocation("astralsorcery", "shapeless/" + name);
            this.output = ItemUtils.copyStackWithSize(output, output.func_190916_E());
        }

        public static Builder newShapelessRecipe(String name, Block output) {
            return Builder.newShapelessRecipe(name, new ItemStack(output));
        }

        public static Builder newShapelessRecipe(String name, Item output) {
            return Builder.newShapelessRecipe(name, new ItemStack(output));
        }

        public static Builder newShapelessRecipe(String name, ItemStack output) {
            return new Builder(name, output);
        }

        public Builder add(Block block) {
            return this.add(new ItemStack(block));
        }

        public Builder add(Item item) {
            return this.add(new ItemStack(item));
        }

        public Builder add(ItemStack stack) {
            if (this.inputs.size() >= 9) {
                return this;
            }
            this.inputs.add((Object)new ItemHandle(stack));
            return this;
        }

        public Builder add(String oreDictName) {
            if (this.inputs.size() >= 9) {
                return this;
            }
            this.inputs.add((Object)new ItemHandle(oreDictName));
            return this;
        }

        public Builder addPart(FluidStack fluidStack) {
            if (this.inputs.size() >= 9) {
                return this;
            }
            this.inputs.add((Object)new ItemHandle(fluidStack));
            return this;
        }

        public Builder addPart(Fluid fluid, int mbAmount) {
            return this.addPart(new FluidStack(fluid, mbAmount));
        }

        public Builder addPart(Fluid fluid) {
            return this.addPart(fluid, 1000);
        }

        public Builder addPart(ItemHandle handle) {
            if (this.inputs.size() >= 9) {
                return this;
            }
            this.inputs.add((Object)handle);
            return this;
        }

        public AccessibleRecipeAdapater buildAndRegisterShapelessRecipe() {
            if (this.registered) {
                throw new IllegalArgumentException("Tried to register previously built recipe twice!");
            }
            this.registered = true;
            BasePlainRecipe actual = RecipeHelper.getShapelessOreDictRecipe(this.entry, this.output, this.compileIngredients());
            CommonProxy.registryPrimer.register(actual);
            ShapelessRecipe access = new ShapelessRecipe(this.output, this.inputs);
            return new AccessibleRecipeAdapater(actual, access);
        }

        private NonNullList<Ingredient> compileIngredients() {
            NonNullList ingredients = NonNullList.func_191196_a();
            for (ItemHandle handle : this.inputs) {
                ingredients.add((Object)handle.getRecipeIngredient());
            }
            return ingredients;
        }
    }
}

