/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTree;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.MajorPerk;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class PerkTreeConnector
extends MajorPerk {
    private static List<PerkTreeConnector> connectorCache = Lists.newArrayList();

    public PerkTreeConnector(String name, int x, int y) {
        super(name, x, y);
        this.setCategory(CATEGORY_EPIPHANY);
        connectorCache.add(this);
    }

    @Override
    public boolean mayUnlockPerk(PlayerProgress progress, EntityPlayer player) {
        if (!progress.hasFreeAllocationPoint(player) || !this.canSee(player, progress)) {
            return false;
        }
        boolean hasAllAdjacent = true;
        for (AbstractPerk otherPerks : PerkTree.PERK_TREE.getConnectedPerks(this)) {
            if (progress.hasPerkEffect(otherPerks)) continue;
            hasAllAdjacent = false;
            break;
        }
        if (!hasAllAdjacent) {
            for (PerkTreeConnector conn : connectorCache) {
                if (!progress.hasPerkEffect(conn)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void onUnlockPerkServer(EntityPlayer player, PlayerProgress progress, NBTTagCompound dataStorage) {
        super.onUnlockPerkServer(player, progress, dataStorage);
        NBTTagList listTokens = new NBTTagList();
        for (AbstractPerk otherPerk : PerkTree.PERK_TREE.getConnectedPerks(this)) {
            String token;
            if (!ResearchManager.forceApplyPerk(player, otherPerk) || !ResearchManager.grantFreePerkPoint(player, token = "connector-tk-" + otherPerk.getRegistryName().toString())) continue;
            listTokens.func_74742_a((NBTBase)new NBTTagString(token));
        }
        dataStorage.func_74782_a("pointtokens", (NBTBase)listTokens);
    }

    @Override
    public void onRemovePerkServer(EntityPlayer player, PlayerProgress progress, NBTTagCompound dataStorage) {
        super.onRemovePerkServer(player, progress, dataStorage);
        NBTTagList list = dataStorage.func_150295_c("pointtokens", 8);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            String token = list.func_150307_f(i);
            ResearchManager.revokeFreePoint(player, token);
        }
    }
}

