/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.attribute;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.PlayerAttributeMap;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.AttributeConverterPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.AttributeTypeRegistry;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeType;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AttributeModifierPerk
extends AttributeConverterPerk {
    private List<PerkAttributeModifier> typeModifierList = Lists.newArrayList();

    public AttributeModifierPerk(String name, int x, int y) {
        super(name, x, y);
    }

    public AttributeModifierPerk(ResourceLocation name, int x, int y) {
        super(name, x, y);
    }

    @Nullable
    public <T extends PerkAttributeModifier> T addModifier(float modifier, PerkAttributeModifier.Mode mode, String type) {
        PerkAttributeType attrType = AttributeTypeRegistry.getType(type);
        if (attrType != null) {
            return (T)this.addModifier(attrType.createModifier(modifier, mode));
        }
        return null;
    }

    @Nullable
    protected <T extends PerkAttributeModifier> T addModifier(T modifier) {
        this.typeModifierList.add(modifier);
        return modifier;
    }

    @Override
    protected void applyEffectMultiplier(double multiplier) {
        super.applyEffectMultiplier(multiplier);
        this.typeModifierList.forEach(t -> t.multiplyValue(multiplier));
    }

    protected Collection<PerkAttributeModifier> getModifiers(EntityPlayer player, Side side) {
        if (this.modifiersDisabled(player, side)) {
            return Collections.emptyList();
        }
        return new ArrayList<PerkAttributeModifier>(this.typeModifierList);
    }

    @Override
    public void applyPerkLogic(EntityPlayer player, Side side) {
        super.applyPerkLogic(player, side);
        PlayerProgress prog = ResearchManager.getProgress(player, side);
        PlayerAttributeMap attr = PerkAttributeHelper.getOrCreateMap(player, side);
        for (PerkAttributeModifier modifier : this.getModifiers(player, side)) {
            ArrayList modify = Lists.newArrayList();
            modify.add(modifier);
            modify.addAll(attr.gainModifiers(player, prog, modifier, this));
            for (PerkAttributeModifier mod : modify) {
                if (attr.applyModifier(player, (mod = attr.convertModifier(player, prog, mod, this)).getAttributeType(), mod)) continue;
            }
        }
    }

    @Override
    public void removePerkLogic(EntityPlayer player, Side side) {
        super.removePerkLogic(player, side);
        PlayerProgress prog = ResearchManager.getProgress(player, side);
        PlayerAttributeMap attr = PerkAttributeHelper.getOrCreateMap(player, side);
        for (PerkAttributeModifier modifier : this.getModifiers(player, side)) {
            ArrayList modify = Lists.newArrayList();
            modify.add(modifier);
            modify.addAll(attr.gainModifiers(player, prog, modifier, this));
            for (PerkAttributeModifier mod : modify) {
                if (attr.removeModifier(player, (mod = attr.convertModifier(player, prog, mod, this)).getAttributeType(), mod)) continue;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addLocalizedTooltip(Collection<String> tooltip) {
        boolean addEmptyLine;
        Collection<PerkAttributeModifier> modifiers = this.getModifiers((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Side.CLIENT);
        boolean bl = addEmptyLine = !modifiers.isEmpty();
        if (this.canSeeClient()) {
            for (PerkAttributeModifier modifier : modifiers) {
                String modifierDisplay = modifier.getLocalizedDisplayString();
                if (modifierDisplay != null) {
                    tooltip.add(modifierDisplay);
                    continue;
                }
                addEmptyLine = false;
            }
        }
        return addEmptyLine;
    }
}

