/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.charge;

import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktSyncCharge;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerChargeHandler
implements ITickHandler {
    public static final PlayerChargeHandler INSTANCE = new PlayerChargeHandler();
    private Map<EntityPlayer, Float> chargeMap = new HashMap<EntityPlayer, Float>();
    public float clientCharge = 0.0f;

    private PlayerChargeHandler() {
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        EntityPlayer pl;
        float charge;
        if (context[1] == Side.SERVER && (charge = this.getCharge(pl = (EntityPlayer)context[0])) < 1.0f) {
            if (pl.func_184812_l_()) {
                charge = 1.0f;
            } else {
                float chargeGain = 0.01f;
                float dayMult = ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution(pl.func_130014_f_());
                chargeGain *= 0.5f + dayMult * 0.5f;
                if (pl.func_130014_f_().func_175678_i(pl.func_180425_c().func_177984_a())) {
                    chargeGain *= 6.0f;
                }
                charge = MathHelper.func_76131_a((float)(charge + chargeGain), (float)0.0f, (float)1.0f);
            }
            this.setCharge(pl, charge);
            PktSyncCharge ch = new PktSyncCharge(charge);
            PacketChannel.CHANNEL.sendTo((IMessage)ch, (EntityPlayerMP)pl);
        }
    }

    public void informDisconnect(EntityPlayer player) {
        this.chargeMap.remove(player);
    }

    public float getCharge(EntityPlayer player) {
        Float ret;
        if (!this.chargeMap.containsKey(player)) {
            this.setCharge(player, 1.0f);
            if (player instanceof EntityPlayerMP) {
                PktSyncCharge ch = new PktSyncCharge(1.0f);
                PacketChannel.CHANNEL.sendTo((IMessage)ch, (EntityPlayerMP)player);
            }
        }
        return (ret = this.chargeMap.get(player)) == null ? 0.0f : ret.floatValue();
    }

    public void setCharge(EntityPlayer player, float charge) {
        this.chargeMap.put(player, Float.valueOf(MathHelper.func_76131_a((float)charge, (float)0.0f, (float)1.0f)));
    }

    public boolean hasAtLeast(EntityPlayer player, float toTest) {
        return this.getCharge(player) >= toTest;
    }

    public void drainCharge(EntityPlayer player, float toDrain) {
        float charge = this.getCharge(player);
        charge = Math.max(0.0f, charge - toDrain);
        this.setCharge(player, charge);
    }

    public void setClientCharge(float pktIncCharge) {
        this.clientCharge = pktIncCharge;
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "PlayerCharge Handler";
    }
}

