/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.cape.impl;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.cape.CapeArmorEffect;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CapeEffectAevitas
extends CapeArmorEffect {
    private static final int ticksPerRound = 30;
    private static float range = 10.0f;
    private static float potency = 1.0f;
    private static float turnChance = 0.2f;
    private static float healPerCycle = 0.04f;
    private static float feedChancePerCycle = 0.01f;
    private static int foodLevelPerCycle = 1;
    private static float foodSaturationLevelPerCycle = 0.1f;

    public CapeEffectAevitas(NBTTagCompound cmp) {
        super(cmp, "aevitas");
    }

    @Override
    public IConstellation getAssociatedConstellation() {
        return Constellations.aevitas;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playActiveParticleTick(EntityPlayer pl) {
        this.playConstellationCapeSparkles(pl, 0.1f);
        Color c = this.getAssociatedConstellation().getConstellationColor();
        if (c != null) {
            EntityFXFacingParticle p;
            double x = pl.field_70165_t + (double)(pl.field_70130_N / 2.0f);
            double y = pl.field_70163_u;
            double z = pl.field_70161_v + (double)(pl.field_70130_N / 2.0f);
            Vector3 centerOffset = new Vector3(x, y, z);
            float tick = ClientScheduler.getClientTick() % 30L;
            Vector3 axis = Vector3.RotAxis.Y_AXIS;
            Vector3 circleVec = axis.clone().perpendicular().normalize().multiply((double)range * 0.9 * (double)rand.nextFloat());
            double deg = 360.0 * (double)(tick / 30.0f);
            Vector3 mov = circleVec.clone().rotate(Math.toRadians(deg), axis.clone());
            Vector3 at = mov.clone().add(centerOffset);
            if ((double)rand.nextFloat() < 0.2) {
                p = EffectHelper.genericFlareParticle(at);
                p.setColor(c).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
                p.scale(rand.nextFloat() * 0.5f + 0.3f);
                if (rand.nextInt(3) == 0) {
                    p.setColor(IConstellation.weak);
                }
                p.setMaxAge(30 + rand.nextInt(20));
                if (rand.nextFloat() < 0.8f) {
                    p = EffectHelper.genericFlareParticle(at);
                    p.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
                    p.scale(rand.nextFloat() * 0.2f + 0.1f);
                    p.setMaxAge(20 + rand.nextInt(10));
                }
            }
            if ((double)rand.nextFloat() < 0.2) {
                mov = circleVec.clone().rotate(Math.toRadians(deg += 180.0), axis.clone());
                at = mov.clone().add(centerOffset);
                p = EffectHelper.genericFlareParticle(at);
                p.setColor(c).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
                p.scale(rand.nextFloat() * 0.5f + 0.3f);
                if (rand.nextInt(3) == 0) {
                    p.setColor(IConstellation.weak);
                }
                p.setMaxAge(30 + rand.nextInt(20));
                if (rand.nextFloat() < 0.8f) {
                    p = EffectHelper.genericFlareParticle(at);
                    p.setColor(Color.WHITE).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT);
                    p.scale(rand.nextFloat() * 0.2f + 0.1f);
                    p.setMaxAge(20 + rand.nextInt(10));
                }
            }
        }
    }

    public float getTurnChance() {
        return turnChance;
    }

    public float getRange() {
        return range;
    }

    public float getPotency() {
        return potency;
    }

    public float getHealPerCycle() {
        return healPerCycle;
    }

    public int getFoodLevelPerCycle() {
        return foodLevelPerCycle;
    }

    public float getFoodSaturationLevelPerCycle() {
        return foodSaturationLevelPerCycle;
    }

    public float getFeedChancePerCycle() {
        return feedChancePerCycle;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        range = cfg.getFloat(this.getKey() + "Range", this.getConfigurationSection(), range, 1.0f, 32.0f, "Defines the radius (in blocks) for the aoe effect.");
        potency = cfg.getFloat(this.getKey() + "Potency", this.getConfigurationSection(), potency, 0.0f, 1.0f, "Defines the multiplier if the aoe will happen at all");
        turnChance = cfg.getFloat(this.getKey() + "PlantTransformChance", this.getConfigurationSection(), turnChance, 0.0f, 1.0f, "Defines the chance that the aoe will search for a plant to turn into another plant.");
        feedChancePerCycle = cfg.getFloat(this.getKey() + "FeedChancePerCycle", this.getConfigurationSection(), feedChancePerCycle, 0.0f, 1.0f, "Defines the chance that food-level increasing effects will happen on a specific cape-effect-cycle/tick");
        healPerCycle = cfg.getFloat(this.getKey() + "HealPerCycle", this.getConfigurationSection(), healPerCycle, 0.0f, 4.0f, "Defines the amount of health that is regenerated per cape-effect-cycle/tick");
        foodLevelPerCycle = cfg.getInt(this.getKey() + "FoodLevelPerCycle", this.getConfigurationSection(), foodLevelPerCycle, 0, 5, "Defines the food-level that is 'fed' to the player per cape-effect-cycle/tick");
        foodSaturationLevelPerCycle = cfg.getFloat(this.getKey() + "FoodSaturationPerCycle", this.getConfigurationSection(), foodSaturationLevelPerCycle, 0.0f, 5.0f, "Defines the amount of saturation that is 'fed' to the player per cape-effect-cycle/tick");
    }
}

