/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.util.word.RandomWordGenerator;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.star.StarConnection;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.data.fragment.KnowledgeFragment;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientConstellationGenerator {
    public static ClientConstellation generateRandom(long seed) {
        Random sRandom = new Random(seed);
        int stars = 5 + (sRandom.nextFloat() > 0.6f ? 1 : 0);
        return ClientConstellationGenerator.generateRandom(seed, stars);
    }

    public static ClientConstellation generateRandom(long seed, int stars) {
        Random sRandom = new Random(seed);
        String name = RandomWordGenerator.getGenerator().generateWord(seed, sRandom.nextFloat() > 0.6f ? 7 : 6);
        ClientConstellation cst = new ClientConstellation(name);
        ArrayList tmpStars = Lists.newArrayList();
        ArrayList tmpConnections = Lists.newArrayList();
        for (int i = 0; i < stars; ++i) {
            Point newPoint = ClientConstellationGenerator.pickStarPoint(sRandom, tmpStars, 6.0f);
            tmpStars.add(new StarLocation(newPoint.x, newPoint.y));
        }
        Iterator it = tmpStars.iterator();
        while (it.hasNext()) {
            StarLocation sl = (StarLocation)it.next();
            StarLocation other = ClientConstellationGenerator.findConnection(sRandom, sl, tmpStars, tmpConnections);
            if (other == null) {
                it.remove();
                continue;
            }
            tmpConnections.add(new StarConnection(sl, other));
        }
        tmpStars.forEach(s -> cst.addStar(s.x, s.y));
        tmpConnections.forEach(c -> {
            if (cst.getStars().contains(c.to) && cst.getStars().contains(c.from)) {
                cst.addConnection(c.from, c.to);
            }
        });
        return cst;
    }

    private static StarLocation findConnection(Random rand, StarLocation sl, List<StarLocation> stars, List<StarConnection> existingConnections) {
        ArrayList others = Lists.newArrayList(stars);
        others.remove(sl);
        if (others.isEmpty()) {
            return null;
        }
        Collections.shuffle(others, rand);
        block0: for (StarLocation other : others) {
            StarConnection conn = new StarConnection(sl, other);
            for (StarConnection otherConnection : existingConnections) {
                if (!ClientConstellationGenerator.intersect(conn, otherConnection)) continue;
                continue block0;
            }
            return other;
        }
        return null;
    }

    private static boolean intersect(StarConnection sc1, StarConnection sc2) {
        return ClientConstellationGenerator.isIntersecting(sc1, sc2.from.asPoint()) || ClientConstellationGenerator.isIntersecting(sc1, sc2.to.asPoint());
    }

    private static boolean isIntersecting(StarConnection part, Point p) {
        StarConnection originPart = new StarConnection(new StarLocation(0, 0), new StarLocation(part.to.x - part.from.x, part.to.y - part.from.y));
        Point originOffset = new Point(p.x - part.from.x, p.y - part.from.y);
        return ClientConstellationGenerator.cross(originPart.to.asPoint(), originOffset) < 0;
    }

    private static int cross(Point p1, Point p2) {
        return p1.x * p2.y - p2.x * p1.y;
    }

    private static Point pickStarPoint(Random rand, List<StarLocation> occupied, float minDst) {
        Point opt;
        block0: while (true) {
            opt = new Point(rand.nextInt(25), rand.nextInt(25));
            opt.translate(3, 3);
            for (StarLocation other : occupied) {
                if (!(opt.distance(other.asPoint()) < (double)minDst)) continue;
                continue block0;
            }
            break;
        }
        return opt;
    }

    public static class ClientConstellation
    implements IConstellation {
        private List<StarLocation> starLocations = Lists.newArrayList();
        private List<StarConnection> connections = Lists.newArrayList();
        private final String localizedName;
        private KnowledgeFragment associatedFragment;

        private ClientConstellation(String localizedName) {
            this.localizedName = localizedName;
        }

        public void setFragment(KnowledgeFragment fragment) {
            this.associatedFragment = fragment;
        }

        public KnowledgeFragment getFragment() {
            return this.associatedFragment;
        }

        @Override
        public StarLocation addStar(int x, int y) {
            StarLocation star = new StarLocation(x %= 30, y %= 30);
            if (!this.starLocations.contains(star)) {
                this.starLocations.add(star);
                return star;
            }
            return null;
        }

        @Override
        public StarConnection addConnection(StarLocation star1, StarLocation star2) {
            if (star1.equals(star2)) {
                return null;
            }
            StarConnection sc = new StarConnection(star1, star2);
            if (!this.connections.contains(sc)) {
                this.connections.add(sc);
                return sc;
            }
            return null;
        }

        @Override
        public boolean canDiscover(EntityPlayer player, PlayerProgress progress) {
            return true;
        }

        @Override
        public List<StarLocation> getStars() {
            return Collections.unmodifiableList(this.starLocations);
        }

        @Override
        public List<StarConnection> getStarConnections() {
            return Collections.unmodifiableList(this.connections);
        }

        @Override
        public String getSimpleName() {
            return this.localizedName;
        }

        @Override
        public String getUnlocalizedName() {
            return this.localizedName;
        }

        @Override
        public List<ItemHandle> getConstellationSignatureItems() {
            return Lists.newArrayList();
        }

        @Override
        public IConstellation addSignatureItem(ItemHandle item) {
            return this;
        }

        @Override
        public Color getConstellationColor() {
            return IConstellation.weak;
        }
    }
}

