/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.lost.cityassets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mcjty.lostcities.api.ILostCityCityStyle;
import mcjty.lostcities.dimensions.world.lost.cityassets.AssetRegistries;
import mcjty.lostcities.varia.Tools;
import org.apache.commons.lang3.tuple.Pair;

public class CityStyle
implements ILostCityCityStyle {
    private String name;
    private final List<Pair<Float, String>> buildingSelector = new ArrayList<Pair<Float, String>>();
    private final List<Pair<Float, String>> bridgeSelector = new ArrayList<Pair<Float, String>>();
    private final List<Pair<Float, String>> parkSelector = new ArrayList<Pair<Float, String>>();
    private final List<Pair<Float, String>> fountainSelector = new ArrayList<Pair<Float, String>>();
    private final List<Pair<Float, String>> stairSelector = new ArrayList<Pair<Float, String>>();
    private final List<Pair<Float, String>> frontSelector = new ArrayList<Pair<Float, String>>();
    private final List<Pair<Float, String>> railDungeonSelector = new ArrayList<Pair<Float, String>>();
    private final List<Pair<Float, String>> multiBuildingSelector = new ArrayList<Pair<Float, String>>();
    private String style;
    private Integer streetWidth;
    private Integer minFloorCount;
    private Integer minCellarCount;
    private Integer maxFloorCount;
    private Integer maxCellarCount;
    private Float explosionChance;
    private Character streetBlock;
    private Character streetBaseBlock;
    private Character streetVariantBlock;
    private Character parkElevationBlock;
    private Character corridorRoofBlock;
    private Character corridorGlassBlock;
    private Character railMainBlock;
    private Character borderBlock;
    private Character wallBlock;
    private Character sphereBlock;
    private Character sphereSideBlock;
    private Character sphereGlassBlock;
    private String inherit;
    private boolean resolveInherit = false;

    public CityStyle(JsonObject object) {
        this.readFromJSon(object);
    }

    public CityStyle(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public Float getExplosionChance() {
        return this.explosionChance;
    }

    @Override
    public int getStreetWidth() {
        return this.streetWidth;
    }

    @Override
    public Integer getMinFloorCount() {
        return this.minFloorCount;
    }

    @Override
    public Integer getMinCellarCount() {
        return this.minCellarCount;
    }

    @Override
    public Integer getMaxFloorCount() {
        return this.maxFloorCount;
    }

    @Override
    public Integer getMaxCellarCount() {
        return this.maxCellarCount;
    }

    @Override
    public Character getStreetBlock() {
        return this.streetBlock;
    }

    @Override
    public Character getStreetBaseBlock() {
        return this.streetBaseBlock;
    }

    @Override
    public Character getStreetVariantBlock() {
        return this.streetVariantBlock;
    }

    @Override
    public Character getRailMainBlock() {
        return this.railMainBlock;
    }

    @Override
    public Character getParkElevationBlock() {
        return this.parkElevationBlock;
    }

    @Override
    public Character getCorridorRoofBlock() {
        return this.corridorRoofBlock;
    }

    @Override
    public Character getCorridorGlassBlock() {
        return this.corridorGlassBlock;
    }

    @Override
    public Character getBorderBlock() {
        return this.borderBlock;
    }

    @Override
    public Character getWallBlock() {
        return this.wallBlock;
    }

    public Character getSphereBlock() {
        return this.sphereBlock;
    }

    public Character getSphereSideBlock() {
        return this.sphereSideBlock;
    }

    public Character getSphereGlassBlock() {
        return this.sphereGlassBlock;
    }

    @Override
    public void init() {
        if (!this.resolveInherit) {
            this.resolveInherit = true;
            if (this.inherit != null) {
                CityStyle inheritFrom = AssetRegistries.CITYSTYLES.get(this.inherit);
                if (inheritFrom == null) {
                    throw new RuntimeException("Cannot find citystyle '" + this.inherit + "' to inherit from!");
                }
                if (this.style == null) {
                    this.style = inheritFrom.getStyle();
                }
                this.buildingSelector.addAll(inheritFrom.buildingSelector);
                this.bridgeSelector.addAll(inheritFrom.bridgeSelector);
                this.parkSelector.addAll(inheritFrom.parkSelector);
                this.fountainSelector.addAll(inheritFrom.fountainSelector);
                this.stairSelector.addAll(inheritFrom.stairSelector);
                this.frontSelector.addAll(inheritFrom.frontSelector);
                this.railDungeonSelector.addAll(inheritFrom.railDungeonSelector);
                this.multiBuildingSelector.addAll(inheritFrom.multiBuildingSelector);
                if (this.explosionChance == null) {
                    this.explosionChance = inheritFrom.explosionChance;
                }
                if (this.streetWidth == null) {
                    this.streetWidth = inheritFrom.streetWidth;
                }
                if (this.minFloorCount == null) {
                    this.minFloorCount = inheritFrom.minFloorCount;
                }
                if (this.minCellarCount == null) {
                    this.minCellarCount = inheritFrom.minCellarCount;
                }
                if (this.maxFloorCount == null) {
                    this.maxFloorCount = inheritFrom.maxFloorCount;
                }
                if (this.maxCellarCount == null) {
                    this.maxCellarCount = inheritFrom.maxCellarCount;
                }
                if (this.streetBlock == null) {
                    this.streetBlock = inheritFrom.streetBlock;
                }
                if (this.streetBaseBlock == null) {
                    this.streetBaseBlock = inheritFrom.streetBaseBlock;
                }
                if (this.streetVariantBlock == null) {
                    this.streetVariantBlock = inheritFrom.streetVariantBlock;
                }
                if (this.parkElevationBlock == null) {
                    this.parkElevationBlock = inheritFrom.parkElevationBlock;
                }
                if (this.corridorRoofBlock == null) {
                    this.corridorRoofBlock = inheritFrom.corridorRoofBlock;
                }
                if (this.corridorGlassBlock == null) {
                    this.corridorGlassBlock = inheritFrom.corridorGlassBlock;
                }
                if (this.railMainBlock == null) {
                    this.railMainBlock = inheritFrom.railMainBlock;
                }
                if (this.borderBlock == null) {
                    this.borderBlock = inheritFrom.borderBlock;
                }
                if (this.wallBlock == null) {
                    this.wallBlock = inheritFrom.wallBlock;
                }
                if (this.sphereBlock == null) {
                    this.sphereBlock = inheritFrom.sphereBlock;
                }
                if (this.sphereSideBlock == null) {
                    this.sphereSideBlock = inheritFrom.sphereSideBlock;
                }
                if (this.sphereGlassBlock == null) {
                    this.sphereGlassBlock = inheritFrom.sphereGlassBlock;
                }
            }
        }
    }

    @Override
    public void readFromJSon(JsonObject object) {
        JsonObject s;
        this.name = object.get("name").getAsString();
        if (object.has("inherit")) {
            this.inherit = object.get("inherit").getAsString();
        }
        if (object.has("style")) {
            this.style = object.get("style").getAsString();
        }
        if (object.has("explosionchance")) {
            this.explosionChance = Float.valueOf(object.get("explosionchance").getAsFloat());
        }
        if (object.has("streetblocks")) {
            s = object.get("streetblocks").getAsJsonObject();
            if (s.has("border")) {
                this.borderBlock = Character.valueOf(s.get("border").getAsCharacter());
            }
            if (s.has("wall")) {
                this.wallBlock = Character.valueOf(s.get("wall").getAsCharacter());
            }
            if (s.has("street")) {
                this.streetBlock = Character.valueOf(s.get("street").getAsCharacter());
            }
            if (s.has("streetvariant")) {
                this.streetVariantBlock = Character.valueOf(s.get("streetvariant").getAsCharacter());
            }
            if (s.has("streetbase")) {
                this.streetBaseBlock = Character.valueOf(s.get("streetbase").getAsCharacter());
            }
            if (s.has("width")) {
                this.streetWidth = s.get("width").getAsInt();
            }
        }
        if (object.has("buildingsettings")) {
            s = object.get("buildingsettings").getAsJsonObject();
            if (s.has("maxfloors")) {
                this.maxFloorCount = s.get("maxfloors").getAsInt();
            }
            if (s.has("maxcellars")) {
                this.maxCellarCount = s.get("maxcellars").getAsInt();
            }
            if (s.has("minfloors")) {
                this.minFloorCount = s.get("minfloors").getAsInt();
            }
            if (s.has("mincellars")) {
                this.minCellarCount = s.get("mincellars").getAsInt();
            }
        }
        if (object.has("railblocks")) {
            s = object.get("railblocks").getAsJsonObject();
            this.railMainBlock = Character.valueOf(s.get("railmain").getAsCharacter());
        }
        if (object.has("parkblocks")) {
            s = object.get("parkblocks").getAsJsonObject();
            this.parkElevationBlock = Character.valueOf(s.get("elevation").getAsCharacter());
        }
        if (object.has("corridorblocks")) {
            s = object.get("corridorblocks").getAsJsonObject();
            if (s.has("roof")) {
                this.corridorRoofBlock = Character.valueOf(s.get("roof").getAsCharacter());
            }
            if (s.has("glass")) {
                this.corridorGlassBlock = Character.valueOf(s.get("glass").getAsCharacter());
            }
        }
        if (object.has("sphereblocks")) {
            s = object.get("sphereblocks").getAsJsonObject();
            if (s.has("glass")) {
                this.sphereGlassBlock = Character.valueOf(s.get("glass").getAsCharacter());
            }
            if (s.has("border")) {
                this.sphereSideBlock = Character.valueOf(s.get("border").getAsCharacter());
            }
            if (s.has("inner")) {
                this.sphereBlock = Character.valueOf(s.get("inner").getAsCharacter());
            }
        }
        this.parseArraySafe(object, this.buildingSelector, "buildings", "building");
        this.parseArraySafe(object, this.multiBuildingSelector, "multibuildings", "multibuilding");
        this.parseArraySafe(object, this.parkSelector, "parks", "park");
        this.parseArraySafe(object, this.fountainSelector, "fountains", "fountain");
        this.parseArraySafe(object, this.stairSelector, "stairs", "stair");
        this.parseArraySafe(object, this.frontSelector, "fronts", "front");
        this.parseArraySafe(object, this.bridgeSelector, "bridges", "bridge");
        this.parseArraySafe(object, this.railDungeonSelector, "raildungeons", "dungeon");
    }

    private void parseArraySafe(JsonObject object, List<Pair<Float, String>> selector, String arrayName, String elName) {
        JsonArray array = this.getArraySafe(object, arrayName);
        for (JsonElement element : array) {
            if (element.getAsJsonObject().has("clear")) {
                selector.clear();
                continue;
            }
            float factor = element.getAsJsonObject().get("factor").getAsFloat();
            String el = element.getAsJsonObject().get(elName).getAsString();
            selector.add((Pair<Float, String>)Pair.of((Object)Float.valueOf(factor), (Object)el));
        }
    }

    private JsonArray getArraySafe(JsonObject object, String key) {
        if (object.has(key)) {
            return object.get(key).getAsJsonArray();
        }
        return new JsonArray();
    }

    public JsonObject writeToJSon() {
        JsonObject o;
        JsonObject object = new JsonObject();
        object.add("type", (JsonElement)new JsonPrimitive("citystyle"));
        object.add("name", (JsonElement)new JsonPrimitive(this.name));
        object.add("style", (JsonElement)new JsonPrimitive(this.style));
        JsonObject s = new JsonObject();
        s.add("street", (JsonElement)new JsonPrimitive(this.streetBlock));
        s.add("streetvariant", (JsonElement)new JsonPrimitive(this.streetVariantBlock));
        s.add("streetbase", (JsonElement)new JsonPrimitive(this.streetBaseBlock));
        s.add("width", (JsonElement)new JsonPrimitive((Number)this.streetWidth));
        object.add("streetblocks", (JsonElement)s);
        JsonArray array = new JsonArray();
        for (Pair<Float, String> pair : this.buildingSelector) {
            o = new JsonObject();
            o.add("factor", (JsonElement)new JsonPrimitive((Number)pair.getKey()));
            o.add("building", (JsonElement)new JsonPrimitive((String)pair.getValue()));
            array.add((JsonElement)o);
        }
        object.add("buildings", (JsonElement)array);
        array = new JsonArray();
        for (Pair<Float, String> pair : this.multiBuildingSelector) {
            o = new JsonObject();
            o.add("factor", (JsonElement)new JsonPrimitive((Number)pair.getKey()));
            o.add("multibuilding", (JsonElement)new JsonPrimitive((String)pair.getValue()));
            array.add((JsonElement)o);
        }
        object.add("multibuildings", (JsonElement)array);
        array = new JsonArray();
        for (Pair<Float, String> pair : this.parkSelector) {
            o = new JsonObject();
            o.add("factor", (JsonElement)new JsonPrimitive((Number)pair.getKey()));
            o.add("park", (JsonElement)new JsonPrimitive((String)pair.getValue()));
            array.add((JsonElement)o);
        }
        object.add("parks", (JsonElement)array);
        array = new JsonArray();
        for (Pair<Float, String> pair : this.fountainSelector) {
            o = new JsonObject();
            o.add("factor", (JsonElement)new JsonPrimitive((Number)pair.getKey()));
            o.add("fountain", (JsonElement)new JsonPrimitive((String)pair.getValue()));
            array.add((JsonElement)o);
        }
        object.add("fountains", (JsonElement)array);
        array = new JsonArray();
        for (Pair<Float, String> pair : this.stairSelector) {
            o = new JsonObject();
            o.add("factor", (JsonElement)new JsonPrimitive((Number)pair.getKey()));
            o.add("stair", (JsonElement)new JsonPrimitive((String)pair.getValue()));
            array.add((JsonElement)o);
        }
        object.add("stairs", (JsonElement)array);
        array = new JsonArray();
        for (Pair<Float, String> pair : this.frontSelector) {
            o = new JsonObject();
            o.add("factor", (JsonElement)new JsonPrimitive((Number)pair.getKey()));
            o.add("front", (JsonElement)new JsonPrimitive((String)pair.getValue()));
            array.add((JsonElement)o);
        }
        object.add("fronts", (JsonElement)array);
        array = new JsonArray();
        for (Pair<Float, String> pair : this.bridgeSelector) {
            o = new JsonObject();
            o.add("factor", (JsonElement)new JsonPrimitive((Number)pair.getKey()));
            o.add("bridge", (JsonElement)new JsonPrimitive((String)pair.getValue()));
            array.add((JsonElement)o);
        }
        object.add("bridges", (JsonElement)array);
        array = new JsonArray();
        for (Pair<Float, String> pair : this.railDungeonSelector) {
            o = new JsonObject();
            o.add("factor", (JsonElement)new JsonPrimitive((Number)pair.getKey()));
            o.add("dungeon", (JsonElement)new JsonPrimitive((String)pair.getValue()));
            array.add((JsonElement)o);
        }
        object.add("raildungeons", (JsonElement)array);
        return object;
    }

    public String getRandomStair(Random random) {
        return Tools.getRandomFromList(random, this.stairSelector);
    }

    public String getRandomFront(Random random) {
        return Tools.getRandomFromList(random, this.frontSelector);
    }

    public String getRandomRailDungeon(Random random) {
        return Tools.getRandomFromList(random, this.railDungeonSelector);
    }

    public String getRandomPark(Random random) {
        return Tools.getRandomFromList(random, this.parkSelector);
    }

    public String getRandomBridge(Random random) {
        return Tools.getRandomFromList(random, this.bridgeSelector);
    }

    public String getRandomFountain(Random random) {
        return Tools.getRandomFromList(random, this.fountainSelector);
    }

    public String getRandomBuilding(Random random) {
        return Tools.getRandomFromList(random, this.buildingSelector);
    }

    public String getRandomMultiBuilding(Random random) {
        return Tools.getRandomFromList(random, this.multiBuildingSelector);
    }
}

