/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.lost;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.api.ILostSphere;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.dimensions.world.BiomeTranslator;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.lost.BuildingInfo;
import mcjty.lostcities.dimensions.world.lost.City;
import mcjty.lostcities.dimensions.world.lost.cityassets.AssetRegistries;
import mcjty.lostcities.dimensions.world.lost.cityassets.CityStyle;
import mcjty.lostcities.dimensions.world.lost.cityassets.PredefinedCity;
import mcjty.lostcities.dimensions.world.lost.cityassets.PredefinedSphere;
import mcjty.lostcities.varia.ChunkCoord;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class CitySphere
implements ILostSphere {
    private static Map<ChunkCoord, CitySphere> citySphereCache = new HashMap<ChunkCoord, CitySphere>();
    public static final CitySphere EMPTY = new CitySphere(new ChunkCoord(0, 0, 0), 0.0f, new BlockPos(0, 0, 0), false);
    private final ChunkCoord center;
    private final BlockPos centerPos;
    private final float radius;
    private final boolean enabled;
    private Biome biome;
    private boolean monorailNorthCandidate;
    private boolean monorailSouthCandidate;
    private boolean monorailWestCandidate;
    private boolean monorailEastCandidate;
    private char glassBlock = '\u0000';
    private char baseBlock = '\u0000';
    private char sideBlock = '\u0000';

    private CitySphere(ChunkCoord center, float radius, BlockPos centerPos, boolean enabled) {
        this.enabled = enabled;
        this.center = center;
        this.radius = radius;
        this.centerPos = centerPos;
    }

    public static void initSphere(CitySphere sphere, LostCityChunkGenerator provider) {
        if (sphere.getBaseBlock() != '\u0000') {
            return;
        }
        ChunkCoord center = sphere.getCenter();
        BuildingInfo info = BuildingInfo.getBuildingInfo(center.getChunkX(), center.getChunkZ(), provider);
        CityStyle cs = info.getCityStyle();
        Random rand = new Random(info.provider.seed + (long)center.getChunkX() * 837971201L + (long)center.getChunkZ() * 961744153L);
        rand.nextFloat();
        rand.nextFloat();
        Character glass = info.getCompiledPalette().get(cs.getSphereGlassBlock().charValue(), rand);
        Character base = info.getCompiledPalette().get(cs.getSphereBlock().charValue(), rand);
        Character side = info.getCompiledPalette().get(cs.getSphereSideBlock().charValue(), rand);
        sphere.setBlocks(glass.charValue(), base.charValue(), side.charValue());
    }

    public static boolean isInSphere(int chunkX, int chunkZ, BlockPos pos, LostCityChunkGenerator provider) {
        double sqdist;
        CitySphere citySphere;
        boolean sphere = false;
        if (provider.getProfile().isSpace() && (citySphere = CitySphere.getCitySphere(chunkX, chunkZ, provider)).isEnabled() && (sqdist = CitySphere.squaredDistance(citySphere.getCenterPos().func_177958_n(), citySphere.getCenterPos().func_177952_p(), pos.func_177958_n(), pos.func_177952_p())) <= (double)(citySphere.getRadius() * citySphere.getRadius())) {
            sphere = true;
        }
        return sphere;
    }

    public static float getRelativeDistanceToCityCenter(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        CitySphere sphere = CitySphere.getCitySphere(chunkX, chunkZ, provider);
        BlockPos centerPos = sphere.getCenterPos();
        float radius = sphere.getRadius();
        int cx = chunkX * 16 + 8;
        int cz = chunkZ * 16 + 8;
        int sqdist = (cx - centerPos.func_177958_n()) * (cx - centerPos.func_177958_n()) + (cz - centerPos.func_177952_p()) * (cz - centerPos.func_177952_p());
        return (float)(Math.sqrt(sqdist) / (double)radius);
    }

    private static boolean hasNonStationMonoRail(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        if (!CitySphere.fullyInsideCitySpere(chunkX, chunkZ, provider)) {
            return CitySphere.hasHorizontalMonorail(chunkX, chunkZ, provider) || CitySphere.hasVerticalMonorail(chunkX, chunkZ, provider);
        }
        return false;
    }

    public static boolean hasMonorailStation(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        if (CitySphere.fullyInsideCitySpere(chunkX, chunkZ, provider)) {
            return CitySphere.hasNonStationMonoRail(chunkX - 1, chunkZ, provider) || CitySphere.hasNonStationMonoRail(chunkX + 1, chunkZ, provider) || CitySphere.hasNonStationMonoRail(chunkX, chunkZ - 1, provider) || CitySphere.hasNonStationMonoRail(chunkX, chunkZ + 1, provider);
        }
        return false;
    }

    @Override
    public ChunkCoord getCenter() {
        return this.center;
    }

    @Override
    public BlockPos getCenterPos() {
        return this.centerPos;
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    @Override
    @Nullable
    public Biome getBiome() {
        return this.biome;
    }

    public void setBlocks(char glassBlock, char baseBlock, char sideBlock) {
        this.glassBlock = glassBlock;
        this.baseBlock = baseBlock;
        this.sideBlock = sideBlock;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public char getGlassBlock() {
        return this.glassBlock;
    }

    public char getBaseBlock() {
        return this.baseBlock;
    }

    public char getSideBlock() {
        return this.sideBlock;
    }

    public static void cleanCache() {
        citySphereCache.clear();
    }

    public static boolean hasHorizontalMonorail(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        if ((chunkZ & 0xF) == 8) {
            CitySphere sphere;
            int cx;
            boolean result = false;
            for (cx = chunkX + 1; cx < chunkX + 64; ++cx) {
                if ((cx & 0xF) != 8 || !(sphere = CitySphere.getCitySphere(cx, chunkZ, provider)).isEnabled()) continue;
                if (!sphere.monorailWestCandidate) {
                    return false;
                }
                result = true;
                break;
            }
            if (!result) {
                return false;
            }
            result = false;
            for (cx = chunkX - 1; cx > chunkX - 64; --cx) {
                if ((cx & 0xF) != 8 || !(sphere = CitySphere.getCitySphere(cx, chunkZ, provider)).isEnabled()) continue;
                if (!sphere.monorailEastCandidate) {
                    return false;
                }
                result = true;
                break;
            }
            return result;
        }
        return false;
    }

    public static boolean hasVerticalMonorail(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        if ((chunkX & 0xF) == 8) {
            CitySphere sphere;
            int cz;
            boolean result = false;
            for (cz = chunkZ + 1; cz < chunkZ + 64; ++cz) {
                if ((cz & 0xF) != 8 || !(sphere = CitySphere.getCitySphere(chunkX, cz, provider)).isEnabled()) continue;
                if (!sphere.monorailNorthCandidate) {
                    return false;
                }
                result = true;
                break;
            }
            if (!result) {
                return false;
            }
            result = false;
            for (cz = chunkZ - 1; cz > chunkZ - 64; --cz) {
                if ((cz & 0xF) != 8 || !(sphere = CitySphere.getCitySphere(chunkX, cz, provider)).isEnabled()) continue;
                if (!sphere.monorailSouthCandidate) {
                    return false;
                }
                result = true;
                break;
            }
            return result;
        }
        return false;
    }

    private static float getSphereRadius(ChunkCoord center, LostCityChunkGenerator provider, Random rand) {
        PredefinedCity city = City.getPredefinedCity(center.getChunkX(), center.getChunkZ(), provider);
        LostCityProfile profile = provider.getProfile();
        if (city != null) {
            return (float)city.getRadius() * profile.CITYSPHERE_FACTOR;
        }
        return (float)profile.CITY_MINRADIUS + (float)rand.nextInt(profile.CITY_MAXRADIUS - profile.CITY_MINRADIUS) * profile.CITYSPHERE_FACTOR;
    }

    public static boolean fullyInsideCitySpere(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        int cz;
        CitySphere sphere = CitySphere.getCitySphere(chunkX, chunkZ, provider);
        if (!sphere.isEnabled()) {
            return false;
        }
        float radius = sphere.getRadius();
        BlockPos cc = sphere.getCenterPos();
        double sqradiusOffset = (radius - 2.0f) * (radius - 2.0f);
        int cx = cc.func_177958_n();
        if (CitySphere.squaredDistance(cx, cz = cc.func_177952_p(), chunkX * 16, chunkZ * 16) > sqradiusOffset) {
            return false;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16 + 15, chunkZ * 16) > sqradiusOffset) {
            return false;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16, chunkZ * 16 + 15) > sqradiusOffset) {
            return false;
        }
        return !(CitySphere.squaredDistance(cx, cz, chunkX * 16 + 15, chunkZ * 16 + 15) > sqradiusOffset);
    }

    public static boolean intersectsWithCitySphere(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        CitySphere sphere = CitySphere.getCitySphere(chunkX, chunkZ, provider);
        if (!sphere.isEnabled()) {
            return false;
        }
        float radius = sphere.getRadius();
        BlockPos cc = sphere.getCenterPos();
        return CitySphere.intersectChunkWithSphere(chunkX, chunkZ, radius, cc);
    }

    private static boolean intersectChunkWithSphere(int chunkX, int chunkZ, float radius, BlockPos cc) {
        int cz;
        double sqradiusOffset = radius * radius;
        int cx = cc.func_177958_n();
        if (CitySphere.squaredDistance(cx, cz = cc.func_177952_p(), chunkX * 16, chunkZ * 16) <= sqradiusOffset) {
            return true;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16 + 15, chunkZ * 16) <= sqradiusOffset) {
            return true;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16, chunkZ * 16 + 15) <= sqradiusOffset) {
            return true;
        }
        return CitySphere.squaredDistance(cx, cz, chunkX * 16 + 15, chunkZ * 16 + 15) <= sqradiusOffset;
    }

    public static boolean onCitySphereBorder(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        CitySphere sphere = CitySphere.getCitySphere(chunkX, chunkZ, provider);
        if (!sphere.isEnabled()) {
            return false;
        }
        float radius = sphere.getRadius();
        BlockPos cc = sphere.getCenterPos();
        double sqradiusOffset = radius * radius;
        int cx = cc.func_177958_n();
        int cz = cc.func_177952_p();
        int cnt = 0;
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16, chunkZ * 16) <= sqradiusOffset) {
            ++cnt;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16 + 15, chunkZ * 16) <= sqradiusOffset) {
            ++cnt;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16, chunkZ * 16 + 15) <= sqradiusOffset) {
            ++cnt;
        }
        if (CitySphere.squaredDistance(cx, cz, chunkX * 16 + 15, chunkZ * 16 + 15) <= sqradiusOffset) {
            ++cnt;
        }
        return cnt > 0 && cnt < 4;
    }

    public static double squaredDistance(int cx, int cz, int x, int z) {
        return (cx - x) * (cx - x) + (cz - z) * (cz - z);
    }

    private static CitySphere getSphereAtCenter(ChunkCoord center, LostCityChunkGenerator provider, @Nullable PredefinedSphere predef) {
        CitySphere citySphere;
        block6: {
            LostCityProfile profile;
            Random rand;
            block7: {
                int chunkX = center.getChunkX();
                int chunkZ = center.getChunkZ();
                rand = new Random(provider.seed + (long)chunkX * 961744153L + (long)chunkZ * 837971201L);
                rand.nextFloat();
                rand.nextFloat();
                profile = provider.getProfile();
                boolean enabled = predef != null || rand.nextFloat() < profile.CITYSPHERE_CHANCE;
                float radius = predef != null ? (float)predef.getRadius() : CitySphere.getSphereRadius(center, provider, rand);
                BlockPos centerPosition = predef != null ? new BlockPos(predef.getCenterX(), profile.GROUNDLEVEL, predef.getCenterZ()) : CitySphere.getSphereCenterPosition(center, provider, rand);
                citySphere = new CitySphere(center, radius, centerPosition, enabled);
                if (!enabled) break block6;
                citySphere.monorailNorthCandidate = rand.nextFloat() < profile.CITYSPHERE_MONORAIL_CHANCE;
                citySphere.monorailSouthCandidate = rand.nextFloat() < profile.CITYSPHERE_MONORAIL_CHANCE;
                citySphere.monorailWestCandidate = rand.nextFloat() < profile.CITYSPHERE_MONORAIL_CHANCE;
                boolean bl = citySphere.monorailEastCandidate = rand.nextFloat() < profile.CITYSPHERE_MONORAIL_CHANCE;
                if (predef == null || predef.getBiome() == null) break block7;
                citySphere.biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(predef.getBiome()));
                if (citySphere.biome != null) break block6;
                LostCities.logger.warn("Could not find biome '" + predef.getBiome() + "'!");
                break block6;
            }
            if (profile.CITYSPHERE_SINGLE_BIOME) {
                if (profile.ALLOWED_BIOME_FACTORS.length == 0) {
                    ArrayList biomeKeys = new ArrayList(ForgeRegistries.BIOMES.getKeys());
                    biomeKeys.sort((l1, l2) -> l1.compareTo(l2));
                    citySphere.biome = (Biome)ForgeRegistries.BIOMES.getValue((ResourceLocation)biomeKeys.get(rand.nextInt(biomeKeys.size())));
                } else {
                    List<Pair<Float, Biome>> pairs = BiomeTranslator.parseBiomes(profile.ALLOWED_BIOME_FACTORS);
                    float total = 0.0f;
                    for (Pair<Float, Biome> pair : pairs) {
                        total += 3.0f / ((Float)pair.getKey()).floatValue();
                    }
                    if ((double)total > 0.001) {
                        float f = rand.nextFloat() * total;
                        for (Pair<Float, Biome> pair : pairs) {
                            if (!((f -= 3.0f / ((Float)pair.getKey()).floatValue()) <= 0.0f)) continue;
                            citySphere.biome = (Biome)pair.getRight();
                            break;
                        }
                    }
                }
            }
        }
        return citySphere;
    }

    @Nonnull
    public static CitySphere getCitySphere(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        ChunkCoord coord = new ChunkCoord(provider.dimensionId, chunkX, chunkZ);
        if (!citySphereCache.containsKey(coord)) {
            CitySphere sphere;
            for (PredefinedSphere predef : AssetRegistries.PREDEFINED_SPHERES.getIterable()) {
                if (predef.getDimension() != provider.dimensionId || !CitySphere.intersectChunkWithSphere(chunkX, chunkZ, predef.getRadius(), new BlockPos(predef.getCenterX(), 0, predef.getCenterZ()))) continue;
                ChunkCoord center = new ChunkCoord(provider.dimensionId, predef.getChunkX(), predef.getChunkZ());
                CitySphere sphere2 = CitySphere.getSphereAtCenter(center, provider, predef);
                CitySphere.updateCache(coord, sphere2);
                return sphere2;
            }
            if (provider.getProfile().CITYSPHERE_ONLY_PREDEFINED) {
                sphere = EMPTY;
            } else {
                int cx = (chunkX & 0xFFFFFFF0) + 8;
                int cz = (chunkZ & 0xFFFFFFF0) + 8;
                ChunkCoord center = new ChunkCoord(provider.dimensionId, cx, cz);
                sphere = CitySphere.getSphereAtCenter(center, provider, null);
            }
            CitySphere.updateCache(coord, sphere);
            return sphere;
        }
        return citySphereCache.get(coord);
    }

    private static void updateCache(ChunkCoord coord, CitySphere sphere) {
        citySphereCache.put(coord, sphere);
        BlockPos centerPos = sphere.getCenterPos();
        int radius = (int)sphere.getRadius();
        if ((float)radius < 1.0E-4f) {
            citySphereCache.put(sphere.center, sphere);
            return;
        }
        for (int cx = centerPos.func_177958_n() - radius - 16; cx <= centerPos.func_177958_n() + radius + 16; cx += 16) {
            for (int cz = centerPos.func_177952_p() - radius - 16; cz <= centerPos.func_177952_p() + radius + 16; cz += 16) {
                ChunkCoord cc = new ChunkCoord(sphere.getCenter().getDimension(), cx >> 4, cz >> 4);
                if (!CitySphere.intersectChunkWithSphere(cc.getChunkX(), cc.getChunkZ(), radius, centerPos)) continue;
                citySphereCache.put(cc, sphere);
            }
        }
    }

    private static BlockPos getSphereCenterPosition(ChunkCoord center, LostCityChunkGenerator provider, Random rand) {
        int cx = center.getChunkX() * 16 + rand.nextInt(16) - 8;
        int cz = center.getChunkZ() * 16 + rand.nextInt(16) - 8;
        return new BlockPos(cx, provider.getProfile().GROUNDLEVEL, cz);
    }
}

