/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.Log;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.Util;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidUtil {
    @CapabilityInject(value=IFluidHandler.class)
    private static final Capability<IFluidHandler> FLUID_HANDLER = null;
    @CapabilityInject(value=IFluidHandlerItem.class)
    private static final Capability<IFluidHandlerItem> FLUID_ITEM_HANDLER = null;

    @Nonnull
    public static Capability<IFluidHandler> getFluidCapability() {
        return NullHelper.notnullF(FLUID_HANDLER, "IFluidHandler capability is missing");
    }

    @Nonnull
    public static Capability<IFluidHandlerItem> getFluidItemCapability() {
        return NullHelper.notnullF(FLUID_ITEM_HANDLER, "IFluidHandlerItem capability is missing");
    }

    @Nullable
    public static IFluidHandler getFluidHandlerCapability(@Nullable ICapabilityProvider provider, @Nullable EnumFacing side) {
        if (provider != null && provider.hasCapability(FluidUtil.getFluidCapability(), side)) {
            return (IFluidHandler)provider.getCapability(FluidUtil.getFluidCapability(), side);
        }
        return null;
    }

    @Nullable
    public static IFluidHandlerItem getFluidHandlerCapability(@Nonnull ItemStack stack) {
        if (stack.hasCapability(FluidUtil.getFluidItemCapability(), null)) {
            return (IFluidHandlerItem)stack.getCapability(FluidUtil.getFluidItemCapability(), null);
        }
        return null;
    }

    public static EnumMap<EnumFacing, IFluidHandler> getNeighbouringFluidHandlers(final @Nonnull World worldObj, final @Nonnull BlockPos location) {
        final EnumMap<EnumFacing, IFluidHandler> res = new EnumMap<EnumFacing, IFluidHandler>(EnumFacing.class);
        NNList.FACING.apply(new NNList.Callback<EnumFacing>(){

            @Override
            public void apply(@Nonnull EnumFacing dir) {
                IFluidHandler fh = FluidUtil.getFluidHandler(worldObj, location.func_177972_a(dir), dir.func_176734_d());
                if (fh != null) {
                    res.put(dir, fh);
                }
            }
        });
        return res;
    }

    @Nullable
    static IFluidHandler getFluidHandler(@Nonnull World worldObj, @Nonnull BlockPos location, @Nullable EnumFacing side) {
        return FluidUtil.getFluidHandlerCapability((ICapabilityProvider)worldObj.func_175625_s(location), side);
    }

    public static FluidStack getFluidTypeFromItem(@Nonnull ItemStack stack) {
        Fluid fluid;
        if (stack.func_190926_b()) {
            return null;
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(1);
        IFluidHandlerItem handler = FluidUtil.getFluidHandlerCapability(copy);
        if (handler != null) {
            return handler.drain(1000, false);
        }
        if (Block.func_149634_a((Item)copy.func_77973_b()) instanceof IFluidBlock && (fluid = ((IFluidBlock)Block.func_149634_a((Item)copy.func_77973_b())).getFluid()) != null) {
            return new FluidStack(fluid, 1000);
        }
        return null;
    }

    public static boolean isFluidContainer(@Nonnull ItemStack stack) {
        return FluidUtil.getFluidHandlerCapability(stack) != null;
    }

    public static boolean isFluidContainer(@Nonnull ICapabilityProvider provider, @Nullable EnumFacing side) {
        if (provider instanceof ItemStack) {
            Log.warn("isFluidContainer(ICapabilityProvider, EnumFacing) is not for ItemStacks");
            return FluidUtil.isFluidContainer((ItemStack)provider);
        }
        return FluidUtil.getFluidHandlerCapability(provider, side) != null;
    }

    public static boolean hasEmptyCapacity(@Nonnull ItemStack stack) {
        IFluidHandlerItem handler = FluidUtil.getFluidHandlerCapability(stack);
        if (handler == null) {
            return false;
        }
        IFluidTankProperties[] props = handler.getTankProperties();
        if (props == null) {
            return false;
        }
        for (IFluidTankProperties tank : props) {
            int cap = tank.getCapacity();
            FluidStack contents = tank.getContents();
            if (cap < 0 || contents != null && contents.amount >= cap) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static FluidAndStackResult tryFillContainer(@Nonnull ItemStack target, @Nullable FluidStack source) {
        if (target.func_190926_b() || source == null || source.getFluid() == null || source.amount <= 0) {
            return new FluidAndStackResult(ItemStack.field_190927_a, null, target, source);
        }
        ItemStack filledStack = target.func_77946_l();
        filledStack.func_190920_e(1);
        IFluidHandlerItem handler = FluidUtil.getFluidHandlerCapability(filledStack);
        if (handler == null) {
            return new FluidAndStackResult(ItemStack.field_190927_a, null, target, source);
        }
        int filledAmount = handler.fill(source.copy(), true);
        if (filledAmount <= 0 || filledAmount > source.amount) {
            return new FluidAndStackResult(ItemStack.field_190927_a, null, target, source);
        }
        filledStack = handler.getContainer();
        FluidStack resultFluid = source.copy();
        resultFluid.amount = filledAmount;
        ItemStack remainderStack = target.func_77946_l();
        remainderStack.func_190918_g(1);
        FluidStack remainderFluid = source.copy();
        remainderFluid.amount -= filledAmount;
        if (remainderFluid.amount <= 0) {
            remainderFluid = null;
        }
        return new FluidAndStackResult(filledStack, resultFluid, remainderStack, remainderFluid);
    }

    @Nonnull
    public static FluidAndStackResult tryDrainContainer(@Nonnull ItemStack source, @Nullable FluidStack target, int capacity) {
        FluidStack drained;
        if (source.func_190926_b()) {
            return new FluidAndStackResult(ItemStack.field_190927_a, null, source, target);
        }
        ItemStack emptiedStack = source.func_77946_l();
        emptiedStack.func_190920_e(1);
        IFluidHandlerItem handler = FluidUtil.getFluidHandlerCapability(emptiedStack);
        if (handler == null) {
            return new FluidAndStackResult(null, ItemStack.field_190927_a, target, source);
        }
        int maxDrain = capacity - (target != null ? target.amount : 0);
        if (target != null) {
            FluidStack available = target.copy();
            available.amount = maxDrain;
            drained = handler.drain(available, true);
        } else {
            drained = handler.drain(maxDrain, true);
        }
        if (drained == null || drained.amount <= 0 || drained.amount > maxDrain) {
            return new FluidAndStackResult(ItemStack.field_190927_a, null, source, target);
        }
        emptiedStack = handler.getContainer();
        ItemStack remainderStack = source.func_77946_l();
        remainderStack.func_190918_g(1);
        FluidStack remainderFluid = target != null ? target.copy() : new FluidStack(drained, 0);
        remainderFluid.amount += drained.amount;
        return new FluidAndStackResult(emptiedStack, drained, remainderStack, remainderFluid);
    }

    @Nonnull
    public static FluidAndStackResult tryDrainContainer(@Nonnull ItemStack source, @Nonnull ITankAccess tank) {
        FluidAndStackResult result = new FluidAndStackResult(null, ItemStack.field_190927_a, null, source);
        if (source.func_190926_b()) {
            return result;
        }
        IFluidHandlerItem handler = FluidUtil.getFluidHandlerCapability(source);
        if (handler == null) {
            return result;
        }
        FluidStack contentType = FluidUtil.getFluidTypeFromItem(source);
        if (contentType == null) {
            return result;
        }
        FluidTank targetTank = tank.getInputTank(contentType);
        if (targetTank == null) {
            return result;
        }
        return FluidUtil.tryDrainContainer(source, targetTank.getFluid(), targetTank.getCapacity());
    }

    public static boolean fillPlayerHandItemFromInternalTank(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand hand, @Nonnull ITankAccess tank) {
        ItemStack heldItem = entityPlayer.func_184586_b(hand);
        boolean doFill = !entityPlayer.field_71075_bZ.field_75098_d || heldItem.func_77973_b() != Items.field_151133_ar;
        for (FluidTank subTank : tank.getOutputTanks()) {
            FluidAndStackResult fill = FluidUtil.tryFillContainer(entityPlayer.func_184586_b(hand), subTank.getFluid());
            if (fill.result.fluidStack == null) continue;
            subTank.setFluid(fill.remainder.fluidStack);
            tank.setTanksDirty();
            if (doFill) {
                if (fill.remainder.itemStack.func_190926_b()) {
                    entityPlayer.func_184611_a(hand, fill.result.itemStack);
                    return true;
                }
                entityPlayer.func_184611_a(hand, fill.remainder.itemStack);
                if (fill.result.itemStack.func_190926_b()) {
                    return true;
                }
                if (entityPlayer.field_71071_by.func_70441_a(fill.result.itemStack)) {
                    return true;
                }
                if (!world.field_72995_K) {
                    double x0 = ((double)pos.func_177958_n() + 0.5 + entityPlayer.field_70165_t) / 2.0;
                    double y0 = ((double)pos.func_177956_o() + 0.5 + entityPlayer.field_70163_u + 0.5) / 2.0;
                    double z0 = ((double)pos.func_177952_p() + 0.5 + entityPlayer.field_70161_v) / 2.0;
                    Util.dropItems(world, fill.result.itemStack, x0, y0, z0, true);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean fillInternalTankFromPlayerHandItem(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand hand, @Nonnull ITankAccess tank) {
        FluidAndStackResult fill = FluidUtil.tryDrainContainer(entityPlayer.func_184586_b(hand), tank);
        if (fill.result.fluidStack == null) {
            return false;
        }
        FluidTank inputTank = tank.getInputTank(fill.result.fluidStack);
        if (inputTank == null) {
            return false;
        }
        inputTank.setFluid(fill.remainder.fluidStack);
        tank.setTanksDirty();
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            if (fill.remainder.itemStack.func_190926_b()) {
                entityPlayer.func_184611_a(hand, fill.result.itemStack);
                return true;
            }
            entityPlayer.func_184611_a(hand, fill.remainder.itemStack);
            if (fill.result.itemStack.func_190926_b()) {
                return true;
            }
            if (entityPlayer.field_71071_by.func_70441_a(fill.result.itemStack)) {
                return true;
            }
            if (!world.field_72995_K) {
                double x0 = ((double)pos.func_177958_n() + 0.5 + entityPlayer.field_70165_t) / 2.0;
                double y0 = ((double)pos.func_177956_o() + 0.5 + entityPlayer.field_70163_u + 0.5) / 2.0;
                double z0 = ((double)pos.func_177952_p() + 0.5 + entityPlayer.field_70161_v) / 2.0;
                Util.dropItems(world, fill.result.itemStack, x0, y0, z0, true);
            }
        }
        return true;
    }

    public static boolean areFluidsTheSame(@Nullable Fluid fluid, @Nullable Fluid fluid2) {
        if (fluid == null) {
            return fluid2 == null;
        }
        if (fluid2 == null) {
            return false;
        }
        return fluid == fluid2 || fluid.getName().equals(fluid2.getName());
    }

    public static class FluidAndStackResult {
        @Nonnull
        public final FluidAndStack result;
        @Nonnull
        public final FluidAndStack remainder;

        public FluidAndStackResult(@Nonnull FluidAndStack result, @Nonnull FluidAndStack remainder) {
            this.result = result;
            this.remainder = remainder;
        }

        public FluidAndStackResult(FluidStack fluidStackResult, @Nonnull ItemStack itemStackResult, FluidStack fluidStackRemainder, @Nonnull ItemStack itemStackRemainder) {
            this.result = new FluidAndStack(fluidStackResult, itemStackResult);
            this.remainder = new FluidAndStack(fluidStackRemainder, itemStackRemainder);
        }

        public FluidAndStackResult(@Nonnull ItemStack itemStackResult, FluidStack fluidStackResult, @Nonnull ItemStack itemStackRemainder, FluidStack fluidStackRemainder) {
            this.result = new FluidAndStack(fluidStackResult, itemStackResult);
            this.remainder = new FluidAndStack(fluidStackRemainder, itemStackRemainder);
        }
    }

    public static class FluidAndStack {
        @Nullable
        public final FluidStack fluidStack;
        @Nonnull
        public final ItemStack itemStack;

        public FluidAndStack(@Nullable FluidStack fluidStack, @Nonnull ItemStack itemStack) {
            this.fluidStack = fluidStack;
            this.itemStack = itemStack;
        }

        public FluidAndStack(@Nonnull ItemStack itemStack, @Nullable FluidStack fluidStack) {
            this.fluidStack = fluidStack;
            this.itemStack = itemStack;
        }
    }
}

