/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.tweaks;

import com.enderio.core.common.config.AbstractConfigHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;

public abstract class Tweak {
    private final String name;
    private final String comment;
    private final AbstractConfigHandler.RestartReqs restartReq;
    private boolean enabled;

    public Tweak(String key, String comment) {
        this(key, comment, AbstractConfigHandler.RestartReqs.REQUIRES_MC_RESTART);
    }

    public Tweak(String key, String comment, AbstractConfigHandler.RestartReqs restartReq) {
        this.name = key;
        this.comment = comment;
        this.restartReq = restartReq;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public AbstractConfigHandler.RestartReqs getRestartReq() {
        return this.restartReq;
    }

    protected void load() {
    }

    protected void unload() {
    }

    private boolean checkGameState() {
        return this.restartReq == AbstractConfigHandler.RestartReqs.NONE || this.restartReq == AbstractConfigHandler.RestartReqs.REQUIRES_WORLD_RESTART && FMLCommonHandler.instance().getMinecraftServerInstance() == null || !Loader.instance().hasReachedState(LoaderState.AVAILABLE);
    }

    public final void enable() {
        if (!this.enabled && this.checkGameState()) {
            this.load();
            this.enabled = true;
        }
    }

    public final void disable() {
        if (this.enabled && this.checkGameState()) {
            this.unload();
            this.enabled = false;
        }
    }
}

