/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.transform;

import com.enderio.core.common.transform.EnderCorePlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class SimpleMixinPatcher
implements IClassTransformer {
    private final EnderCorePlugin plugin = EnderCorePlugin.instance();
    private final Map<String, byte[]> capturedSources = new HashMap<String, byte[]>();

    public byte[] transform(String name, String transformedName, byte[] targetClass) {
        ArrayList<EnderCorePlugin.InterfacePatchData> patches = new ArrayList<EnderCorePlugin.InterfacePatchData>();
        for (EnderCorePlugin.InterfacePatchData d : this.plugin.ifacePatches) {
            if (d.target.equals(transformedName)) {
                patches.add(d);
            }
            if (!d.source.equals(transformedName)) continue;
            this.capturedSources.put(transformedName, targetClass);
            EnderCorePlugin.mixinLogger.info("Found mixin source class data for {}.", (Object)transformedName);
        }
        if (!patches.isEmpty()) {
            EnderCorePlugin.mixinLogger.info("Patching {} mixins onto class {}", (Object)patches.size(), (Object)transformedName);
            ClassNode targetNode = new ClassNode();
            ClassReader targetReader = new ClassReader(targetClass);
            targetReader.accept((ClassVisitor)targetNode, 0);
            for (EnderCorePlugin.InterfacePatchData data : patches) {
                byte[] sourceClass = this.capturedSources.get(data.source);
                if (sourceClass == null) {
                    EnderCorePlugin.mixinLogger.error("Skipping mixin patch due to unloaded class: " + data.source);
                    continue;
                }
                ClassNode sourceNode = new ClassNode();
                ClassReader sourceReader = new ClassReader(sourceClass);
                sourceReader.accept((ClassVisitor)sourceNode, 0);
                for (MethodNode m2 : sourceNode.methods) {
                    for (AbstractInsnNode node : m2.instructions) {
                        if (!(node instanceof MethodInsnNode)) continue;
                        MethodInsnNode call = (MethodInsnNode)node;
                        if (!call.owner.replace('/', '.').equals(data.source)) continue;
                        call.owner = data.target.replace('.', '/');
                        if (call.getOpcode() != 185) continue;
                        call.setOpcode(182);
                        call.itf = false;
                    }
                    if (m2.localVariables.size() <= 0) continue;
                    LocalVariableNode n = (LocalVariableNode)m2.localVariables.get(0);
                    n.desc = "L" + data.target.replace('.', '/') + ";";
                }
                targetNode.interfaces.addAll(sourceNode.interfaces.stream().filter(s -> !targetNode.interfaces.contains(s)).collect(Collectors.toList()));
                targetNode.methods.addAll(sourceNode.methods.stream().filter(m -> !m.name.equals("<init>")).filter(m -> (m.access & 0x400) == 0).collect(Collectors.toList()));
                EnderCorePlugin.mixinLogger.info("Added methods and interfaces from class {}", (Object)data.source);
            }
            ClassWriter cw = new ClassWriter(3);
            targetNode.accept((ClassVisitor)cw);
            EnderCorePlugin.mixinLogger.info("Successfully patched.");
            return cw.toByteArray();
        }
        return targetClass;
    }
}

