/*
 * Decompiled with CFR 0.152.
 */
package net.ellertonCMMShade.japng.map;

import java.io.IOException;
import java.util.ArrayList;
import net.ellertonCMMShade.japng.PngChunkCode;
import net.ellertonCMMShade.japng.error.PngException;
import net.ellertonCMMShade.japng.map.PngChunkMap;
import net.ellertonCMMShade.japng.map.PngMap;
import net.ellertonCMMShade.japng.reader.PngReader;
import net.ellertonCMMShade.japng.reader.PngSource;

public class PngMapReader
implements PngReader<PngMap> {
    PngMap map = new PngMap();

    public PngMapReader(String sourceName) {
        this.map.source = sourceName;
        this.map.chunks = new ArrayList<PngChunkMap>(4);
    }

    @Override
    public boolean readChunk(PngSource source, int code, int dataLength) throws PngException, IOException {
        int dataPosition = source.tell();
        source.skip(dataLength);
        int chunkChecksum = source.readInt();
        this.map.chunks.add(new PngChunkMap(PngChunkCode.from(code), dataPosition, dataLength, chunkChecksum));
        return code == 1229278788;
    }

    @Override
    public void finishedChunks(PngSource source) throws PngException, IOException {
    }

    @Override
    public PngMap getResult() {
        return this.map;
    }
}

