/*
 * Decompiled with CFR 0.152.
 */
package net.ellertonCMMShade.japng.chunks;

import java.util.ArrayList;
import java.util.List;
import net.ellertonCMMShade.japng.map.PngChunkMap;

public class PngFrameControl {
    public final int sequenceNumber;
    public final int width;
    public final int height;
    public final int xOffset;
    public final int yOffset;
    public final short delayNumerator;
    public final short delayDenominator;
    public final byte disposeOp;
    public final byte blendOp;
    List<PngChunkMap> imageChunks = new ArrayList<PngChunkMap>(1);

    public PngFrameControl(int sequenceNumber, int width, int height, int xOffset, int yOffset, short delayNumerator, short delayDenominator, byte disposeOp, byte blendOp) {
        this.sequenceNumber = sequenceNumber;
        this.width = width;
        this.height = height;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.delayNumerator = delayNumerator;
        this.delayDenominator = (short)(delayDenominator == 0 ? 100 : (int)delayDenominator);
        this.disposeOp = disposeOp;
        this.blendOp = blendOp;
    }

    public int getDelayMilliseconds() {
        if (this.delayDenominator == 1000) {
            return this.delayNumerator;
        }
        float f = 1000 / this.delayDenominator;
        return (int)((float)this.delayNumerator * f);
    }

    public void appendImageData(PngChunkMap chunkMap) {
        this.imageChunks.add(chunkMap);
    }

    public List<PngChunkMap> getImageChunks() {
        return this.imageChunks;
    }

    public String toString() {
        return "PngFrameControl{sequenceNumber=" + this.sequenceNumber + ", width=" + this.width + ", height=" + this.height + ", xOffset=" + this.xOffset + ", yOffset=" + this.yOffset + ", delayNumerator=" + this.delayNumerator + ", delayDenominator=" + this.delayDenominator + ", disposeOp=" + this.disposeOp + ", blendOp=" + this.blendOp + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PngFrameControl that = (PngFrameControl)o;
        if (this.sequenceNumber != that.sequenceNumber) {
            return false;
        }
        if (this.width != that.width) {
            return false;
        }
        if (this.height != that.height) {
            return false;
        }
        if (this.xOffset != that.xOffset) {
            return false;
        }
        if (this.yOffset != that.yOffset) {
            return false;
        }
        if (this.delayNumerator != that.delayNumerator) {
            return false;
        }
        if (this.delayDenominator != that.delayDenominator) {
            return false;
        }
        if (this.disposeOp != that.disposeOp) {
            return false;
        }
        return this.blendOp == that.blendOp;
    }

    public int hashCode() {
        int result = this.sequenceNumber;
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.xOffset;
        result = 31 * result + this.yOffset;
        result = 31 * result + this.delayNumerator;
        result = 31 * result + this.delayDenominator;
        result = 31 * result + this.disposeOp;
        result = 31 * result + this.blendOp;
        return result;
    }
}

