/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons;

import io.github.drmanganese.topaddons.TOPAddons;
import io.github.drmanganese.topaddons.addons.AddonBlank;
import io.github.drmanganese.topaddons.api.TOPAddon;
import io.github.drmanganese.topaddons.config.capabilities.IClientOptsCapability;
import io.github.drmanganese.topaddons.elements.tconstruct.ElementSmelteryTank;
import java.util.List;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.smeltery.ISmelteryTankHandler;
import slimeknights.tconstruct.library.smeltery.SmelteryTank;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileTinkerTank;

@TOPAddon(dependency="tconstruct")
public class AddonTinkersConstruct
extends AddonBlank {
    @Override
    public void registerElements() {
        this.registerElement("smeltery", ElementSmelteryTank::new);
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tile = world.func_175625_s(data.getPos());
        if (tile instanceof ISmelteryTankHandler) {
            SmelteryTank tank = ((ISmelteryTankHandler)tile).getTank();
            if (tile instanceof TileSmeltery) {
                boolean inIngots = ((IClientOptsCapability)player.getCapability(TOPAddons.OPTS_CAP, null)).getBoolean("smelteryInIngots");
                this.addSmelteryTankElement(probeInfo, tank.getFluids(), Math.max(tank.getFluidAmount(), tank.getCapacity()), inIngots, mode, player);
            }
            if (tile instanceof TileTinkerTank) {
                AddonTinkersConstruct.textPrefixed(probeInfo, "Capacity", tank.getCapacity() / 1000 + " B");
                this.addSmelteryTankElement(probeInfo, tank.getFluids(), Math.max(tank.getFluidAmount(), tank.getCapacity()), false, mode, player);
            }
        }
    }

    private void addSmelteryTankElement(IProbeInfo probeInfo, List<FluidStack> fluids, int capacity, boolean inIngots, ProbeMode mode, EntityPlayer player) {
        probeInfo.element((IElement)new ElementSmelteryTank(AddonTinkersConstruct.getElementId(player, "smeltery"), fluids, capacity, inIngots, mode == ProbeMode.EXTENDED));
    }
}

