/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.module;

import gnu.trove.map.hash.THashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import wanion.lib.module.AbstractModule;
import wanion.lib.module.LoadStage;

public final class ModuleHandler {
    private final Set<Class<? extends AbstractModule>> moduleClasses = new HashSet<Class<? extends AbstractModule>>();
    private final Map<String, AbstractModule> nameModuleMap = new HashMap<String, AbstractModule>();
    private final Map<AbstractModule, AbstractModule.Manager> modules = new THashMap();

    public void startModules(FMLStateEvent event) {
        LoadStage loadStage;
        LoadStage loadStage2 = loadStage = event != null ? LoadStage.getStage(event.getClass()) : null;
        if (this.modules.isEmpty() || loadStage == null) {
            return;
        }
        this.modules.entrySet().forEach(e -> {
            AbstractModule.Manager manager;
            AbstractModule module = (AbstractModule)e.getKey();
            if (e.getValue() == null) {
                e.setValue(module.manager);
            }
            if ((manager = (AbstractModule.Manager)e.getValue()).isEmpty()) {
                module.init();
            }
            if (!manager.isEmpty(loadStage)) {
                module.start(loadStage, manager);
            }
        });
    }

    public void addModule(AbstractModule module) {
        Class<?> moduleClass;
        Class<?> clazz = moduleClass = module != null ? module.getClass() : null;
        if (moduleClass == null || this.moduleClasses.contains(moduleClass)) {
            return;
        }
        this.moduleClasses.add(moduleClass);
        this.nameModuleMap.put(module.getModuleName(), module);
        this.modules.put(module, null);
    }

    public AbstractModule getModule(@Nonnull String moduleName) {
        return this.nameModuleMap.get(moduleName);
    }
}

