/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaTooltipDisplay;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemMod;

public class ItemManaMirror
extends ItemMod
implements IManaItem,
ICoordBoundItem,
IManaTooltipDisplay {
    private static final String TAG_MANA = "mana";
    private static final String TAG_MANA_BACKLOG = "manaBacklog";
    private static final String TAG_POS_X = "posX";
    private static final String TAG_POS_Y = "posY";
    private static final String TAG_POS_Z = "posZ";
    private static final String TAG_DIM = "dim";
    private static final DummyPool fallbackPool = new DummyPool();

    public ItemManaMirror() {
        super("manaMirror");
        this.func_77625_d(1);
        this.func_77656_e(1000);
        this.setNoRepair();
    }

    public int getDamage(ItemStack stack) {
        float mana = this.getMana(stack);
        return 1000 - (int)(mana / 1000000.0f * 1000.0f);
    }

    public void func_77663_a(ItemStack par1ItemStack, World world, Entity par3Entity, int par4, boolean par5) {
        if (world.field_72995_K) {
            return;
        }
        IManaPool pool = this.getManaPool(par1ItemStack);
        if (!(pool instanceof DummyPool)) {
            if (pool == null) {
                this.setMana(par1ItemStack, 0);
            } else {
                pool.recieveMana(this.getManaBacklog(par1ItemStack));
                this.setManaBacklog(par1ItemStack, 0);
                this.setMana(par1ItemStack, pool.getCurrentMana());
            }
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float par8, float par9, float par10) {
        TileEntity tile;
        if (player.func_70093_af() && !world.field_72995_K && (tile = world.func_175625_s(pos)) != null && tile instanceof IManaPool) {
            this.bindPool(player.func_184586_b(hand), tile);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.ding, SoundCategory.PLAYERS, 1.0f, 1.0f);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public int getMana(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA, 0);
    }

    public void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt(stack, TAG_MANA, Math.max(0, mana));
    }

    public int getManaBacklog(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA_BACKLOG, 0);
    }

    public void setManaBacklog(ItemStack stack, int backlog) {
        ItemNBTHelper.setInt(stack, TAG_MANA_BACKLOG, backlog);
    }

    @Override
    public int getMaxMana(ItemStack stack) {
        return 1000000;
    }

    @Override
    public void addMana(ItemStack stack, int mana) {
        this.setMana(stack, this.getMana(stack) + mana);
        this.setManaBacklog(stack, this.getManaBacklog(stack) + mana);
    }

    public void bindPool(ItemStack stack, TileEntity pool) {
        ItemNBTHelper.setInt(stack, TAG_POS_X, pool == null ? 0 : pool.func_174877_v().func_177958_n());
        ItemNBTHelper.setInt(stack, TAG_POS_Y, pool == null ? -1 : pool.func_174877_v().func_177956_o());
        ItemNBTHelper.setInt(stack, TAG_POS_Z, pool == null ? 0 : pool.func_174877_v().func_177952_p());
        ItemNBTHelper.setInt(stack, TAG_DIM, pool == null ? 0 : pool.func_145831_w().field_73011_w.getDimension());
    }

    public BlockPos getPoolCoords(ItemStack stack) {
        int x = ItemNBTHelper.getInt(stack, TAG_POS_X, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_POS_Y, -1);
        int z = ItemNBTHelper.getInt(stack, TAG_POS_Z, 0);
        return new BlockPos(x, y, z);
    }

    public int getDimension(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_DIM, 0);
    }

    public IManaPool getManaPool(ItemStack stack) {
        TileEntity tile;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return fallbackPool;
        }
        BlockPos coords = this.getPoolCoords(stack);
        if (coords.func_177956_o() == -1) {
            return null;
        }
        int dim = this.getDimension(stack);
        WorldServer world = null;
        for (WorldServer w : server.field_71305_c) {
            if (w.field_73011_w.getDimension() != dim) continue;
            world = w;
            break;
        }
        if (world != null && (tile = world.func_175625_s(coords)) != null && tile instanceof IManaPool) {
            return (IManaPool)tile;
        }
        return null;
    }

    @Override
    public boolean canReceiveManaFromPool(ItemStack stack, TileEntity pool) {
        return false;
    }

    @Override
    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
        return false;
    }

    @Override
    public boolean canExportManaToPool(ItemStack stack, TileEntity pool) {
        return false;
    }

    @Override
    public boolean canExportManaToItem(ItemStack stack, ItemStack otherStack) {
        return true;
    }

    @Override
    public boolean isNoExport(ItemStack stack) {
        return false;
    }

    @Override
    public BlockPos getBinding(ItemStack stack) {
        IManaPool pool = this.getManaPool(stack);
        return pool == null || pool instanceof DummyPool ? null : this.getPoolCoords(stack);
    }

    @Override
    public float getManaFractionForDisplay(ItemStack stack) {
        return (float)this.getMana(stack) / (float)this.getMaxMana(stack);
    }

    private static class DummyPool
    implements IManaPool {
        private DummyPool() {
        }

        @Override
        public boolean isFull() {
            return false;
        }

        @Override
        public void recieveMana(int mana) {
        }

        @Override
        public boolean canRecieveManaFromBursts() {
            return false;
        }

        @Override
        public int getCurrentMana() {
            return 0;
        }

        @Override
        public boolean isOutputtingPower() {
            return false;
        }

        @Override
        public EnumDyeColor getColor() {
            return EnumDyeColor.WHITE;
        }

        @Override
        public void setColor(EnumDyeColor color) {
        }
    }
}

