/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.DrumVariant;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.item.ItemGrassHorn;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockForestDrum
extends BlockMod
implements IManaTrigger,
ILexiconable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.1875, 0.0625, 0.1875, 0.8125, 0.9375, 0.8125);

    public BlockForestDrum() {
        super(Material.field_151575_d, "forestDrum");
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.DRUM_VARIANT, (Comparable)((Object)DrumVariant.WILD)));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.DRUM_VARIANT});
    }

    public int func_176201_c(IBlockState state) {
        return ((DrumVariant)((Object)state.func_177229_b(BotaniaStateProps.DRUM_VARIANT))).ordinal();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta >= DrumVariant.values().length) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a(BotaniaStateProps.DRUM_VARIANT, (Comparable)((Object)DrumVariant.values()[meta]));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 3; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    public void onBurstCollision(IManaBurst burst, World world, BlockPos pos) {
        if (burst.isFake()) {
            return;
        }
        if (world.field_72995_K) {
            world.func_175688_a(EnumParticleTypes.NOTE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, 0.041666666666666664, 0.0, 0.0, new int[0]);
            return;
        }
        DrumVariant variant = (DrumVariant)((Object)world.func_180495_p(pos).func_177229_b(BotaniaStateProps.DRUM_VARIANT));
        if (variant == DrumVariant.WILD) {
            ItemGrassHorn.breakGrass(world, null, 0, pos);
        } else if (variant == DrumVariant.CANOPY) {
            ItemGrassHorn.breakGrass(world, null, 1, pos);
        } else {
            EntityItem ent;
            int range = 10;
            List entities = world.func_72872_a(EntityLiving.class, new AxisAlignedBB(pos.func_177982_a(-range, -range, -range), pos.func_177982_a(range + 1, range + 1, range + 1)));
            ArrayList<EntityLiving> shearables = new ArrayList<EntityLiving>();
            ItemStack stack = new ItemStack((Block)this, 1, 1);
            for (EntityLiving entity : entities) {
                if (entity instanceof IShearable && ((IShearable)entity).isShearable(stack, (IBlockAccess)world, new BlockPos((Entity)entity))) {
                    shearables.add(entity);
                    continue;
                }
                if (!(entity instanceof EntityCow)) continue;
                List items = world.func_72872_a(EntityItem.class, new AxisAlignedBB(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70165_t + (double)entity.field_70130_N, entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v + (double)entity.field_70130_N));
                for (EntityItem item : items) {
                    ItemStack itemstack = item.func_92059_d();
                    if (itemstack.func_190926_b() || itemstack.func_77973_b() != Items.field_151133_ar || world.field_72995_K) continue;
                    while (itemstack.func_190916_E() > 0) {
                        ent = entity.func_70099_a(new ItemStack(Items.field_151117_aB), 1.0f);
                        ent.field_70181_x += (double)(world.field_73012_v.nextFloat() * 0.05f);
                        ent.field_70159_w += (double)((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f);
                        ent.field_70179_y += (double)((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f);
                        itemstack.func_190918_g(1);
                    }
                    item.func_70106_y();
                }
            }
            Collections.shuffle(shearables);
            int sheared = 0;
            for (EntityLiving entity : shearables) {
                if (sheared > 4) break;
                List stacks = ((IShearable)entity).onSheared(stack, (IBlockAccess)world, new BlockPos((Entity)entity), 0);
                if (stacks != null) {
                    for (ItemStack wool : stacks) {
                        ent = entity.func_70099_a(wool, 1.0f);
                        ent.field_70181_x += (double)(world.field_73012_v.nextFloat() * 0.05f);
                        ent.field_70159_w += (double)((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f);
                        ent.field_70179_y += (double)((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f);
                    }
                }
                ++sheared;
            }
        }
        for (int i = 0; i < 10; ++i) {
            world.func_184133_a(null, pos, SoundEvents.field_187676_dE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        DrumVariant variant = (DrumVariant)((Object)world.func_180495_p(pos).func_177229_b(BotaniaStateProps.DRUM_VARIANT));
        switch (variant) {
            case GATHERING: {
                return LexiconData.gatherDrum;
            }
            case CANOPY: {
                return LexiconData.canopyDrum;
            }
        }
        return LexiconData.forestDrum;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelHandler.registerBlockToState(this, DrumVariant.values().length);
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }
}

