/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockEnchanter
extends BlockMod
implements IWandable,
ILexiconable,
IWandHUD {
    public BlockEnchanter() {
        super(Material.field_151576_e, "enchanter");
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149715_a(1.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BotaniaStateProps.ENCHANTER_DIRECTION, (Comparable)EnumFacing.Axis.X));
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.ENCHANTER_DIRECTION});
    }

    public int func_176201_c(IBlockState state) {
        switch ((EnumFacing.Axis)state.func_177229_b(BotaniaStateProps.ENCHANTER_DIRECTION)) {
            case Z: {
                return 1;
            }
        }
        return 0;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BotaniaStateProps.ENCHANTER_DIRECTION, (Comparable)(meta == 1 ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
    }

    @Override
    public boolean registerInCreative() {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEnchanter();
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150368_y);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float par7, float par8, float par9) {
        boolean stackEnchantable;
        TileEnchanter enchanter = (TileEnchanter)world.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == ModItems.twigWand) {
            return false;
        }
        boolean bl = stackEnchantable = !stack.func_190926_b() && stack.func_77973_b() != Items.field_151122_aG && stack.func_77956_u() && stack.func_190916_E() == 1;
        if (enchanter.itemToEnchant.func_190926_b()) {
            if (!stackEnchantable) return false;
            enchanter.itemToEnchant = stack.func_77946_l();
            player.func_184611_a(hand, ItemStack.field_190927_a);
            enchanter.sync();
            return true;
        } else {
            if (enchanter.stage != TileEnchanter.State.IDLE) return true;
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)enchanter.itemToEnchant.func_77946_l());
            enchanter.itemToEnchant = ItemStack.field_190927_a;
            enchanter.sync();
        }
        return true;
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEnchanter enchanter = (TileEnchanter)world.func_175625_s(pos);
        if (!enchanter.itemToEnchant.func_190926_b()) {
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), enchanter.itemToEnchant));
        }
        world.func_175666_e(pos, state.func_177230_c());
        super.func_180663_b(world, pos, state);
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        ((TileEnchanter)world.func_175625_s(pos)).onWanded(player, stack);
        return true;
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.manaEnchanting;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        ((TileEnchanter)world.func_175625_s(pos)).renderHUD(res);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelHandler.registerBlockToState(this, 0, this.func_176223_P().func_177226_a(BotaniaStateProps.ENCHANTER_DIRECTION, (Comparable)EnumFacing.Axis.X));
    }
}

