/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileHourglass;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lexicon.LexiconData;

public class BlockHourglass
extends BlockMod
implements IManaTrigger,
IWandable,
IWandHUD,
ILexiconable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.15, 0.75);

    protected BlockHourglass() {
        super(Material.field_151573_f, "hourglass");
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.POWERED});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BotaniaStateProps.POWERED) != false ? 1 : 0;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float xs, float ys, float zs) {
        TileHourglass hourglass = (TileHourglass)world.func_175625_s(pos);
        ItemStack hgStack = hourglass.getItemHandler().getStackInSlot(0);
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == ModItems.twigWand) {
            return false;
        }
        if (hourglass.lock) {
            if (!player.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("botaniamisc.hourglassLock", new Object[0]));
            }
            return true;
        }
        if (hgStack.func_190926_b() && TileHourglass.getStackItemTime(stack) > 0) {
            hourglass.getItemHandler().setStackInSlot(0, stack.func_77946_l());
            hourglass.func_70296_d();
            stack.func_190920_e(0);
            return true;
        }
        if (!hgStack.func_190926_b()) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)hgStack);
            hourglass.getItemHandler().setStackInSlot(0, ItemStack.field_190927_a);
            hourglass.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return (Boolean)state.func_177229_b((IProperty)BotaniaStateProps.POWERED) != false ? 15 : 0;
    }

    public int func_149738_a(World world) {
        return 4;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)BotaniaStateProps.POWERED)).booleanValue()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)BotaniaStateProps.POWERED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileSimpleInventory inv = (TileSimpleInventory)world.func_175625_s(pos);
        InventoryHelper.dropInventory(inv, world, state, pos);
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileHourglass();
    }

    @Override
    public void onBurstCollision(IManaBurst burst, World world, BlockPos pos) {
        if (!burst.isFake()) {
            TileHourglass tile = (TileHourglass)world.func_175625_s(pos);
            tile.onManaCollide();
        }
    }

    @Override
    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing side) {
        TileHourglass tile = (TileHourglass)world.func_175625_s(pos);
        tile.lock = !tile.lock;
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        TileHourglass tile = (TileHourglass)world.func_175625_s(pos);
        tile.renderHUD(res);
    }

    @Override
    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.hourglass;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.POWERED}).func_178441_a());
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)this), (int)0, TileHourglass.class);
        ModelHandler.registerCustomItemblock(this, "hovering_hourglass");
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }
}

