/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableList;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.IFarmRegistry;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import forestry.core.utils.Log;
import forestry.farming.logic.farmables.FarmableAgingCrop;
import forestry.modules.ModuleHelper;
import forestry.plugins.CompatPlugin;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fluids.FluidStack;

@ForestryModule(containerID="forestry_compat", moduleID="mysticalagriculture", name="Mystical Agriculture", author="Nedelosk", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.mysticalagriculture.description")
public class PluginMysticalAgriculture
extends CompatPlugin {
    private static final String MAGICAL_AGRICULTURE = "mysticalagriculture";

    public PluginMysticalAgriculture() {
        super("Mystical Agriculture", MAGICAL_AGRICULTURE);
    }

    @Override
    public void registerRecipes() {
        if (ModuleHelper.isEnabled("farming")) {
            ImmutableList<String> cropNames = this.getCropNames();
            if (cropNames.isEmpty()) {
                return;
            }
            IFarmRegistry farmRegistry = ForestryAPI.farmRegistry;
            int seedAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
            FluidStack seedOil = Fluids.SEED_OIL.getFluid(seedAmount);
            for (String cropName : cropNames) {
                ItemStack seeds = this.getItemStack(cropName + "_seeds");
                Block block = this.getBlock(cropName + "_crop");
                if (seeds != null && seedOil != null) {
                    RecipeManagers.squeezerManager.addRecipe(10, seeds, seedOil);
                }
                if (seeds == null || block == null) continue;
                farmRegistry.registerFarmables("farmCrops", new FarmableAgingCrop(seeds, block, (IProperty<Integer>)BlockCrops.field_176488_a, 7, (Integer)0));
            }
            for (int i = 1; i <= 5; ++i) {
                ItemStack seeds = this.getItemStack("tier" + i + "_inferium_seeds");
                Block block = this.getBlock("tier" + i + "_inferium_crop");
                if (seeds != null && seedOil != null) {
                    RecipeManagers.squeezerManager.addRecipe(10, seeds, seedOil);
                }
                if (seeds == null || block == null) continue;
                farmRegistry.registerFarmables("farmCrops", new FarmableAgingCrop(seeds, block, (IProperty<Integer>)BlockCrops.field_176488_a, 7, (Integer)0));
            }
        }
    }

    private ImmutableList<String> getCropNames() {
        try {
            Class<?> typeEnum = Class.forName("com.blakebr0.mysticalagriculture.lib.CropType$Type");
            if (typeEnum.getEnumConstants() == null) {
                return ImmutableList.of();
            }
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (Object obj : typeEnum.getEnumConstants()) {
                if (!(obj instanceof IStringSerializable)) continue;
                builder.add((Object)((IStringSerializable)obj).func_176610_l());
            }
            return builder.build();
        }
        catch (ClassNotFoundException e) {
            Log.error("Failed to find the class ('com.blakebr0.mysticalagriculture.lib.CropType$Type') that contains the crop types of 'Mystical Agriculture'.", new Object[0]);
            return ImmutableList.of();
        }
    }
}

