/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.compat;

import forestry.api.circuits.ICircuit;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.IFarmableInfo;
import forestry.api.farming.ISoil;
import forestry.core.utils.Translator;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;

public class FarmingInfoRecipeWrapper
implements IRecipeWrapper {
    private final ItemStack tube;
    private final IFarmProperties properties;
    private final ICircuit circuit;

    public FarmingInfoRecipeWrapper(ItemStack tube, IFarmProperties properties, ICircuit circuit) {
        this.tube = tube;
        this.properties = properties;
        this.circuit = circuit;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        FontRenderer fontRenderer = minecraft.field_71466_p;
        String circuitName = Translator.translateToLocal(this.circuit.getUnlocalizedName());
        fontRenderer.func_78276_b(circuitName, (recipeWidth - fontRenderer.func_78256_a(circuitName)) / 2, 3, Color.darkGray.getRGB());
        String soilName = Translator.translateToLocal("for.jei.farming.soil");
        fontRenderer.func_78276_b(soilName, 18 - fontRenderer.func_78256_a(soilName) / 2, 45, Color.darkGray.getRGB());
        String germlingsName = Translator.translateToLocal("for.jei.farming.germlings");
        fontRenderer.func_78276_b(germlingsName, (recipeWidth - fontRenderer.func_78256_a(germlingsName)) / 2, 45, Color.darkGray.getRGB());
        String productsName = Translator.translateToLocal("for.jei.farming.products");
        fontRenderer.func_78276_b(productsName, 126 - fontRenderer.func_78256_a(productsName) / 2, 45, Color.darkGray.getRGB());
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<List<ItemStack>> inputStacks = new ArrayList<List<ItemStack>>(9);
        ArrayList<List<ItemStack>> outputStacks = new ArrayList<List<ItemStack>>(4);
        inputStacks.add(Collections.singletonList(this.tube));
        ArrayList<ISoil> soils = new ArrayList<ISoil>(this.properties.getSoils());
        FarmingInfoRecipeWrapper.splitItems(inputStacks, 1, soils, ISoil::getResource);
        Collection<IFarmableInfo> farmableInfo = this.properties.getFarmableInfo();
        List germlings = farmableInfo.stream().map(IFarmableInfo::getGermlings).flatMap(Collection::stream).collect(Collectors.toList());
        FarmingInfoRecipeWrapper.splitItems(inputStacks, 5, germlings, item -> item);
        List productions = farmableInfo.stream().map(IFarmableInfo::getProducts).flatMap(Collection::stream).collect(Collectors.toList());
        FarmingInfoRecipeWrapper.splitItems(outputStacks, 0, productions, item -> item);
        ingredients.setInputLists(VanillaTypes.ITEM, inputStacks);
        ingredients.setOutputLists(VanillaTypes.ITEM, outputStacks);
    }

    private static <T> void splitItems(List<List<ItemStack>> items, int startIndex, List<T> values, Function<T, ItemStack> itemFunction) {
        int count = values.size();
        if (count == 0 || count % 4 != 0) {
            count += 4 - count % 4;
        }
        for (int i = 0; i < count; ++i) {
            int index = startIndex + i % 4;
            ItemStack stack = values.size() > i ? itemFunction.apply(values.get(i)) : null;
            FarmingInfoRecipeWrapper.addItemToList(items, index, stack);
        }
    }

    private static void addItemToList(List<List<ItemStack>> items, int index, @Nullable ItemStack stack) {
        List<Object> itemList;
        if (items.size() > index) {
            itemList = items.get(index);
            if (itemList == null) {
                itemList = new ArrayList();
                items.set(index, itemList);
            }
        } else {
            itemList = new ArrayList();
            items.add(itemList);
        }
        itemList.add(stack);
    }
}

