/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjPassiveProvider;
import buildcraft.api.mj.IMjReadable;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.IMjRedstoneReceiver;
import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.config.Config;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.energy.EnergyHelper;
import forestry.energy.EnergyTransferMode;
import forestry.energy.compat.EnergyStorageWrapper;
import forestry.energy.compat.mj.MjConnectorWrapper;
import forestry.energy.compat.mj.MjHelper;
import forestry.energy.compat.mj.MjPassiveProviderWrapper;
import forestry.energy.compat.mj.MjReadableWrapper;
import forestry.energy.compat.mj.MjReceiverWrapper;
import forestry.energy.compat.mj.MjRedstoneReceiverWrapper;
import forestry.energy.compat.tesla.TeslaConsumerWrapper;
import forestry.energy.compat.tesla.TeslaHelper;
import forestry.energy.compat.tesla.TeslaHolderWrapper;
import forestry.energy.compat.tesla.TeslaProducerWrapper;
import javax.annotation.Nullable;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;

public class EnergyManager
extends EnergyStorage
implements IStreamable,
INbtReadable,
INbtWritable {
    private EnergyTransferMode externalMode = EnergyTransferMode.BOTH;

    public EnergyManager(int maxTransfer, int capacity) {
        super(EnergyHelper.scaleForDifficulty(capacity), EnergyHelper.scaleForDifficulty(maxTransfer), EnergyHelper.scaleForDifficulty(maxTransfer));
    }

    public void setExternalMode(EnergyTransferMode externalMode) {
        this.externalMode = externalMode;
    }

    public EnergyTransferMode getExternalMode() {
        return this.externalMode;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int energy;
        if (nbt.func_74764_b("EnergyManager")) {
            NBTTagCompound energyManagerNBT = nbt.func_74775_l("EnergyManager");
            NBTTagCompound energyStorageNBT = energyManagerNBT.func_74775_l("EnergyStorage");
            energy = energyStorageNBT.func_74762_e("Energy");
        } else {
            energy = nbt.func_74762_e("Energy");
        }
        this.setEnergyStored(energy);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Energy", this.energy);
        return nbt;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.func_150787_b(this.energy);
    }

    @Override
    public void readData(PacketBufferForestry data) {
        int energyStored = data.func_150792_a();
        this.setEnergyStored(energyStored);
    }

    public int getMaxEnergyReceived() {
        return this.maxReceive;
    }

    public void drainEnergy(int amount) {
        this.setEnergyStored(this.energy - amount);
    }

    public void generateEnergy(int amount) {
        this.setEnergyStored(this.energy + amount);
    }

    public void setEnergyStored(int energyStored) {
        this.energy = energyStored;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public boolean hasCapability(Capability<?> capability) {
        return Config.enableRF && capability == CapabilityEnergy.ENERGY || Config.enableTesla && this.hasTeslaCapability(capability) || Config.enableMJ && this.hasMjCapability(capability);
    }

    private boolean hasTeslaCapability(Capability<?> capability) {
        return capability == TeslaHelper.TESLA_PRODUCER && this.externalMode.canExtract() || capability == TeslaHelper.TESLA_CONSUMER && this.externalMode.canReceive() || capability == TeslaHelper.TESLA_HOLDER;
    }

    private boolean hasMjCapability(Capability<?> capability) {
        return capability == MjHelper.CAP_READABLE || capability == MjHelper.CAP_CONNECTOR || capability == MjHelper.CAP_PASSIVE_PROVIDER && this.externalMode.canExtract() || capability == MjHelper.CAP_REDSTONE_RECEIVER && this.externalMode.canReceive() || capability == MjHelper.CAP_RECEIVER && this.externalMode.canReceive();
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability) {
        if (!this.hasCapability(capability)) {
            return null;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            EnergyStorageWrapper energyStorage = new EnergyStorageWrapper(this, this.externalMode);
            return (T)CapabilityEnergy.ENERGY.cast((Object)energyStorage);
        }
        if (TeslaHelper.isTeslaCapability(capability)) {
            Capability<ITeslaProducer> teslaProducer = TeslaHelper.TESLA_PRODUCER;
            Capability<ITeslaConsumer> teslaConsumer = TeslaHelper.TESLA_CONSUMER;
            Capability<ITeslaHolder> teslaHolder = TeslaHelper.TESLA_HOLDER;
            if (capability == teslaProducer && this.externalMode.canExtract()) {
                return (T)teslaProducer.cast((Object)new TeslaProducerWrapper(this));
            }
            if (capability == teslaConsumer && this.externalMode.canReceive()) {
                return (T)teslaConsumer.cast((Object)new TeslaConsumerWrapper(this));
            }
            if (capability == teslaHolder) {
                return (T)teslaHolder.cast((Object)new TeslaHolderWrapper(this));
            }
        } else if (MjHelper.isMjCapability(capability)) {
            Capability<IMjConnector> mjConnector = MjHelper.CAP_CONNECTOR;
            Capability<IMjPassiveProvider> mjPassiveProvider = MjHelper.CAP_PASSIVE_PROVIDER;
            Capability<IMjReadable> mjReadable = MjHelper.CAP_READABLE;
            Capability<IMjReceiver> mjReceiver = MjHelper.CAP_RECEIVER;
            Capability<IMjRedstoneReceiver> mjRedstoneReceiver = MjHelper.CAP_REDSTONE_RECEIVER;
            if (capability == mjPassiveProvider && this.externalMode.canExtract()) {
                return (T)mjPassiveProvider.cast((Object)new MjPassiveProviderWrapper(this));
            }
            if (capability == mjReceiver && this.externalMode.canReceive()) {
                return (T)mjReceiver.cast((Object)new MjReceiverWrapper(this));
            }
            if (capability == mjRedstoneReceiver && this.externalMode.canReceive()) {
                return (T)mjRedstoneReceiver.cast((Object)new MjRedstoneReceiverWrapper(this));
            }
            if (capability == mjReadable) {
                return (T)mjReadable.cast((Object)new MjReadableWrapper(this));
            }
            if (capability == mjConnector) {
                return (T)mjConnector.cast((Object)new MjConnectorWrapper(this));
            }
        }
        return null;
    }

    public int calculateRedstone() {
        return MathHelper.func_76141_d((float)((float)this.energy / (float)this.capacity * 14.0f)) + (this.energy > 0 ? 1 : 0);
    }
}

