/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.recipes.jei;

import com.google.common.collect.ArrayListMultimap;
import forestry.core.utils.Translator;
import java.text.NumberFormat;
import java.util.List;
import mezz.jei.api.gui.ITooltipCallback;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class ForestryTooltipCallback
implements ITooltipCallback<ItemStack> {
    private final ArrayListMultimap<Integer, String> tooltips = ArrayListMultimap.create();

    public void onTooltip(int index, boolean input, ItemStack ingredient, List<String> tooltip) {
        List tip = this.tooltips.get((Object)index);
        if (!tip.isEmpty()) {
            tooltip.addAll(tip);
        }
    }

    public void addFortuneTooltip(int index) {
        this.tooltips.get((Object)index).add(TextFormatting.GRAY + Translator.translateToLocalFormatted("for.jei.fortune", new Object[0]));
    }

    public void addChanceTooltip(int index, float chance) {
        if (chance < 0.0f) {
            chance = 0.0f;
        } else if ((double)chance > 1.0) {
            chance = 1.0f;
        }
        NumberFormat percentFormat = NumberFormat.getPercentInstance();
        percentFormat.setMaximumFractionDigits(2);
        String chanceString = String.valueOf(percentFormat.format(chance));
        this.tooltips.get((Object)index).add(TextFormatting.GRAY + Translator.translateToLocalFormatted("for.jei.chance", chanceString));
    }
}

