/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenMahoe
extends WorldGenTree {
    public WorldGenMahoe(ITreeGenData tree) {
        super(tree, 6, 3);
    }

    @Override
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        HashSet<BlockPos> branchCoords = new HashSet<BlockPos>();
        branchCoords.addAll(WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f));
        for (int yBranch = 2; yBranch < this.height - 1; ++yBranch) {
            branchCoords.addAll(WorldGenHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, yBranch, 0), this.girth, 0.15f, 0.25f, Math.round((float)(this.height - yBranch) * 0.75f), 1, 0.25f));
        }
        return branchCoords;
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, List<BlockPos> branchEnds, BlockPos startPos) {
        for (BlockPos branchEnd : branchEnds) {
            WorldGenHelper.generateCylinderFromPos(world, leaf, branchEnd, 2 + this.girth, 2, WorldGenHelper.EnumReplaceMode.AIR);
        }
        int yCenter = this.height - this.girth;
        yCenter = yCenter > 3 ? yCenter : 4;
        WorldGenHelper.generateSphereFromTreeStartPos(world, startPos.func_177982_a(0, yCenter, 0), this.girth, 3 + rand.nextInt(this.girth), leaf, WorldGenHelper.EnumReplaceMode.AIR);
    }
}

