/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import buildcraft.api.statements.ITriggerExternal;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IHiveFrame;
import forestry.apiculture.ApiaryBeeListener;
import forestry.apiculture.ApiaryBeeModifier;
import forestry.apiculture.IApiary;
import forestry.apiculture.gui.ContainerBeeHousing;
import forestry.apiculture.gui.GuiBeeHousing;
import forestry.apiculture.inventory.IApiaryInventory;
import forestry.apiculture.inventory.InventoryApiary;
import forestry.apiculture.tiles.TileBeeHousingBase;
import forestry.apiculture.trigger.ApicultureTriggers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileApiary
extends TileBeeHousingBase
implements IApiary {
    private final IBeeModifier beeModifier = new ApiaryBeeModifier();
    private final IBeeListener beeListener = new ApiaryBeeListener(this);
    private final InventoryApiary inventory = new InventoryApiary();

    public TileApiary() {
        super("apiary");
        this.setInternalInventory(this.inventory);
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    @Override
    public IApiaryInventory getApiaryInventory() {
        return this.inventory;
    }

    public Collection<IBeeModifier> getBeeModifiers() {
        ArrayList<IBeeModifier> beeModifiers = new ArrayList<IBeeModifier>();
        beeModifiers.add(this.beeModifier);
        for (Tuple<IHiveFrame, ItemStack> frame : this.inventory.getFrames()) {
            IHiveFrame hiveFrame = (IHiveFrame)frame.func_76341_a();
            ItemStack stack = (ItemStack)frame.func_76340_b();
            IBeeModifier beeModifier = hiveFrame.getBeeModifier(stack);
            beeModifiers.add(beeModifier);
        }
        return beeModifiers;
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singleton(this.beeListener);
    }

    @Override
    @Optional.Method(modid="buildcraftlib")
    public void addExternalTriggers(Collection<ITriggerExternal> triggers, @Nonnull EnumFacing side, TileEntity tile) {
        super.addExternalTriggers(triggers, side, tile);
        triggers.add(ApicultureTriggers.missingQueen);
        triggers.add(ApicultureTriggers.missingDrone);
        triggers.add(ApicultureTriggers.noFrames);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        ContainerBeeHousing container = new ContainerBeeHousing(player.field_71071_by, this, true);
        return new GuiBeeHousing<ContainerBeeHousing>(this, container, GuiBeeHousing.Icon.APIARY);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerBeeHousing(player.field_71071_by, this, true);
    }
}

