/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.DefaultBeeModifier;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IHiveFrame;
import forestry.api.core.Tabs;
import forestry.core.items.ItemForestry;
import forestry.core.utils.Translator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHiveFrame
extends ItemForestry
implements IHiveFrame {
    private final HiveFrameBeeModifier beeModifier;

    public ItemHiveFrame(int maxDamage, float geneticDecay) {
        this.func_77625_d(1);
        this.func_77656_e(maxDamage);
        this.func_77637_a(Tabs.tabApiculture);
        this.beeModifier = new HiveFrameBeeModifier(geneticDecay);
    }

    @Override
    public ItemStack frameUsed(IBeeHousing housing, ItemStack frame, IBee queen, int wear) {
        frame.func_77964_b(frame.func_77952_i() + wear);
        if (frame.func_77952_i() >= frame.func_77958_k()) {
            return ItemStack.field_190927_a;
        }
        return frame;
    }

    @Override
    public IBeeModifier getBeeModifier(ItemStack frame) {
        return this.beeModifier;
    }

    @Override
    public IBeeModifier getBeeModifier() {
        return this.beeModifier;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        this.beeModifier.addInformation(stack, world, tooltip, advanced);
        if (!stack.func_77951_h()) {
            tooltip.add(Translator.translateToLocalFormatted("item.for.durability", stack.func_77958_k()));
        }
    }

    private static class HiveFrameBeeModifier
    extends DefaultBeeModifier {
        private static final float production = 2.0f;
        private final float geneticDecay;

        public HiveFrameBeeModifier(float geneticDecay) {
            this.geneticDecay = geneticDecay;
        }

        @Override
        public float getProductionModifier(IBeeGenome genome, float currentModifier) {
            return currentModifier < 10.0f ? 2.0f : 1.0f;
        }

        @Override
        public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
            return this.geneticDecay;
        }

        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
            tooltip.add(Translator.translateToLocalFormatted("item.for.bee.modifier.production", Float.valueOf(2.0f)));
            tooltip.add(Translator.translateToLocalFormatted("item.for.bee.modifier.genetic.decay", Float.valueOf(this.geneticDecay)));
        }
    }
}

