/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.blocks;

import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.apiculture.MaterialBeehive;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.multiblock.IAlvearyControllerInternal;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.apiculture.multiblock.TileAlvearyFan;
import forestry.apiculture.multiblock.TileAlvearyHeater;
import forestry.apiculture.multiblock.TileAlvearyHygroregulator;
import forestry.apiculture.multiblock.TileAlvearyPlain;
import forestry.apiculture.multiblock.TileAlvearySieve;
import forestry.apiculture.multiblock.TileAlvearyStabiliser;
import forestry.apiculture.multiblock.TileAlvearySwarmer;
import forestry.apiculture.network.packets.PacketAlvearyChange;
import forestry.core.blocks.BlockStructure;
import forestry.core.tiles.IActivatable;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.ItemTooltipUtil;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockAlveary
extends BlockStructure
implements IStateMapperRegister {
    private static final PropertyEnum<State> STATE = PropertyEnum.func_177709_a((String)"state", State.class);
    private static final PropertyEnum<AlvearyPlainType> PLAIN_TYPE = PropertyEnum.func_177709_a((String)"type", AlvearyPlainType.class);

    public static Map<BlockAlvearyType, BlockAlveary> create() {
        EnumMap<BlockAlvearyType, BlockAlveary> blockMap = new EnumMap<BlockAlvearyType, BlockAlveary>(BlockAlvearyType.class);
        for (final BlockAlvearyType type : BlockAlvearyType.VALUES) {
            BlockAlveary block = new BlockAlveary(){

                @Override
                public BlockAlvearyType getAlvearyType() {
                    return type;
                }
            };
            blockMap.put(type, block);
        }
        return blockMap;
    }

    public BlockAlveary() {
        super(new MaterialBeehive(false));
        BlockAlvearyType alvearyType = this.getAlvearyType();
        IBlockState defaultState = this.field_176227_L.func_177621_b();
        if (alvearyType == BlockAlvearyType.PLAIN) {
            defaultState = defaultState.func_177226_a(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.NORMAL));
        } else if (alvearyType.activatable) {
            defaultState = defaultState.func_177226_a(STATE, (Comparable)((Object)State.OFF));
        }
        this.func_180632_j(defaultState);
        this.func_149711_c(1.0f);
        this.func_149647_a(Tabs.tabApiculture);
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public abstract BlockAlvearyType getAlvearyType();

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public TileEntity func_149915_a(World world, int meta) {
        BlockAlvearyType type = this.getAlvearyType();
        switch (type) {
            case SWARMER: {
                return new TileAlvearySwarmer();
            }
            case FAN: {
                return new TileAlvearyFan();
            }
            case HEATER: {
                return new TileAlvearyHeater();
            }
            case HYGRO: {
                return new TileAlvearyHygroregulator();
            }
            case STABILISER: {
                return new TileAlvearyStabiliser();
            }
            case SIEVE: {
                return new TileAlvearySieve();
            }
        }
        return new TileAlvearyPlain();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, 0, "apiculture/alveary." + (Object)((Object)this.getAlvearyType()));
    }

    protected BlockStateContainer func_180661_e() {
        BlockAlvearyType alvearyType = this.getAlvearyType();
        if (alvearyType == BlockAlvearyType.PLAIN) {
            return new BlockStateContainer((Block)this, new IProperty[]{PLAIN_TYPE});
        }
        if (alvearyType.activatable) {
            return new BlockStateContainer((Block)this, new IProperty[]{STATE});
        }
        return new BlockStateContainer((Block)this, new IProperty[0]);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileAlveary tile = TileUtil.getTile(world, pos, TileAlveary.class);
        if (tile == null) {
            return super.func_176221_a(state, world, pos);
        }
        if (tile instanceof IActivatable) {
            state = ((IActivatable)((Object)tile)).isActive() ? state.func_177226_a(STATE, (Comparable)((Object)State.ON)) : state.func_177226_a(STATE, (Comparable)((Object)State.OFF));
        } else if (this.getAlvearyType() == BlockAlvearyType.PLAIN) {
            if (!((MultiblockLogicAlveary)tile.getMultiblockLogic()).getController().isAssembled()) {
                state = state.func_177226_a(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.NORMAL));
            } else {
                Block blockAbove;
                IBlockState blockStateAbove = world.func_180495_p(pos.func_177984_a());
                if (BlockUtil.isWoodSlabBlock(blockStateAbove, blockAbove = blockStateAbove.func_177230_c(), world, pos)) {
                    List<EnumFacing> blocksTouching = BlockAlveary.getBlocksTouching(world, pos);
                    switch (blocksTouching.size()) {
                        case 3: {
                            state = state.func_177226_a(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.ENTRANCE));
                            break;
                        }
                        case 2: {
                            if (blocksTouching.contains(EnumFacing.SOUTH) && blocksTouching.contains(EnumFacing.EAST) || blocksTouching.contains(EnumFacing.NORTH) && blocksTouching.contains(EnumFacing.WEST)) {
                                state = state.func_177226_a(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.ENTRANCE_LEFT));
                                break;
                            }
                            state = state.func_177226_a(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.ENTRANCE_RIGHT));
                            break;
                        }
                        default: {
                            state = state.func_177226_a(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.NORMAL));
                            break;
                        }
                    }
                } else {
                    state = state.func_177226_a(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.NORMAL));
                }
            }
        }
        return super.func_176221_a(state, world, pos);
    }

    private static List<EnumFacing> getBlocksTouching(IBlockAccess world, BlockPos blockPos) {
        ArrayList<EnumFacing> touching = new ArrayList<EnumFacing>();
        for (EnumFacing direction : EnumFacing.field_176754_o) {
            IBlockState blockState = world.func_180495_p(blockPos.func_177972_a(direction));
            if (!(blockState.func_177230_c() instanceof BlockAlveary)) continue;
            touching.add(direction);
        }
        return touching;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new AlvearyStateMapper(this.getAlvearyType()));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileUtil.actOnTile((IBlockAccess)worldIn, pos, TileAlveary.class, tileAlveary -> {
            IAlvearyControllerInternal alveary = ((MultiblockLogicAlveary)tileAlveary.getMultiblockLogic()).getController();
            alveary.reassemble();
            BlockPos referenceCoord = alveary.getReferenceCoord();
            NetworkUtil.sendNetworkPacket(new PacketAlvearyChange(referenceCoord), referenceCoord, worldIn);
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (GuiScreen.func_146272_n()) {
            tooltip.add(Translator.translateToLocal("tile.for.alveary.tooltip"));
        } else {
            ItemTooltipUtil.addShiftInformation(stack, world, tooltip, flag);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class AlvearyStateMapper
    extends StateMapperBase {
        private final BlockAlvearyType type;

        public AlvearyStateMapper(BlockAlvearyType type) {
            this.type = type;
        }

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            String resourceDomain = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).func_110624_b();
            String resourceLocation = "apiculture/alveary_" + (Object)((Object)this.type);
            String propertyString = this.func_178131_a((Map)state.func_177228_b());
            return new ModelResourceLocation(resourceDomain + ':' + resourceLocation, propertyString);
        }
    }

    private static enum AlvearyPlainType implements IStringSerializable
    {
        NORMAL,
        ENTRANCE,
        ENTRANCE_LEFT,
        ENTRANCE_RIGHT;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    private static enum State implements IStringSerializable
    {
        ON,
        OFF;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

