/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.gui;

import forestry.api.gui.GuiElementAlignment;
import forestry.api.gui.IElementLayout;
import forestry.api.gui.IElementLayoutHelper;
import forestry.api.gui.IGuiElement;
import forestry.api.gui.IItemElement;
import forestry.api.gui.ILabelElement;
import forestry.api.gui.ITextElement;
import forestry.api.gui.style.ITextStyle;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public interface IElementGroup
extends IGuiElement {
    public <E extends IGuiElement> E add(E var1);

    public <E extends IGuiElement> E remove(E var1);

    default public IElementGroup add(IGuiElement ... elements) {
        for (IGuiElement element : elements) {
            this.add((E)element);
        }
        return this;
    }

    default public IElementGroup remove(IGuiElement ... elements) {
        for (IGuiElement element : elements) {
            this.remove((E)element);
        }
        return this;
    }

    default public IElementGroup add(Collection<IGuiElement> elements) {
        elements.forEach(this::add);
        return this;
    }

    default public IElementGroup remove(Collection<IGuiElement> elements) {
        elements.forEach(this::remove);
        return this;
    }

    public void clear();

    @Nullable
    public IGuiElement getLastElement();

    public List<IGuiElement> getElements();

    public IItemElement item(int var1, int var2, ItemStack var3);

    default public IItemElement item(ItemStack itemStack) {
        return this.item(0, 0, itemStack);
    }

    public ILabelElement label(String var1);

    public ILabelElement label(String var1, ITextStyle var2);

    public ILabelElement label(String var1, GuiElementAlignment var2);

    public ILabelElement label(String var1, GuiElementAlignment var2, ITextStyle var3);

    public ILabelElement label(String var1, int var2, int var3, GuiElementAlignment var4, ITextStyle var5);

    public ILabelElement label(String var1, int var2, int var3, int var4, int var5, GuiElementAlignment var6, ITextStyle var7);

    public ITextElement splitText(String var1, int var2);

    public ITextElement splitText(String var1, int var2, ITextStyle var3);

    public ITextElement splitText(String var1, int var2, GuiElementAlignment var3, ITextStyle var4);

    public ITextElement splitText(String var1, int var2, int var3, int var4, GuiElementAlignment var5, ITextStyle var6);

    default public IElementLayout vertical(int width) {
        return this.vertical(0, 0, width);
    }

    public IElementLayout vertical(int var1, int var2, int var3);

    public IElementLayout horizontal(int var1, int var2, int var3);

    default public IElementLayout horizontal(int height) {
        return this.horizontal(0, 0, height);
    }

    public IElementGroup pane(int var1, int var2, int var3, int var4);

    default public IElementGroup pane(int width, int height) {
        return this.pane(0, 0, width, height);
    }

    public IElementLayoutHelper layoutHelper(IElementLayoutHelper.LayoutFactory var1, int var2, int var3);
}

