/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.arboriculture;

import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IFruitFamily;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IFruitProvider {
    public IFruitFamily getFamily();

    public int getColour(ITreeGenome var1, IBlockAccess var2, BlockPos var3, int var4);

    public int getDecorativeColor();

    public boolean isFruitLeaf(ITreeGenome var1, World var2, BlockPos var3);

    default public float getFruitChance(ITreeGenome genome, World world, BlockPos pos) {
        ITreeRoot treeRoot = TreeManager.treeRoot;
        if (treeRoot == null) {
            return 0.0f;
        }
        float yieldModifier = treeRoot.getTreekeepingMode(world).getYieldModifier(genome, 1.0f);
        return genome.getYield() * yieldModifier * 2.5f;
    }

    public int getRipeningPeriod();

    public Map<ItemStack, Float> getProducts();

    public Map<ItemStack, Float> getSpecialty();

    public NonNullList<ItemStack> getFruits(ITreeGenome var1, World var2, BlockPos var3, int var4);

    public String getDescription();

    @Nullable
    public String getModelName();

    public String getModID();

    @Nullable
    public ResourceLocation getSprite(ITreeGenome var1, IBlockAccess var2, BlockPos var3, int var4);

    @Nullable
    public ResourceLocation getDecorativeSprite();

    public boolean requiresFruitBlocks();

    public boolean trySpawnFruitBlock(ITreeGenome var1, World var2, Random var3, BlockPos var4);

    @SideOnly(value=Side.CLIENT)
    public void registerSprites();
}

