/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.powersink;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.capabilities.Capabilities;
import appeng.integration.Integrations;
import appeng.integration.abstraction.IC2PowerSink;
import appeng.tile.AEBaseInvTile;
import appeng.tile.powersink.ForgeEnergyAdapter;
import appeng.tile.powersink.IExternalPowerSink;
import appeng.tile.powersink.TeslaEnergyAdapter;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class AEBasePoweredTile
extends AEBaseInvTile
implements IAEPowerStorage,
IExternalPowerSink {
    private double internalMaxPower = 10000.0;
    private boolean internalPublicPowerStorage = false;
    private AccessRestriction internalPowerFlow = AccessRestriction.READ_WRITE;
    private double internalCurrentPower = 0.0;
    private EnumSet<EnumFacing> internalPowerSides = EnumSet.allOf(EnumFacing.class);
    private final IEnergyStorage forgeEnergyAdapter = new ForgeEnergyAdapter(this);
    private Object teslaEnergyAdapter;
    private IC2PowerSink ic2Sink;

    public AEBasePoweredTile() {
        if (Capabilities.TESLA_CONSUMER != null) {
            this.teslaEnergyAdapter = new TeslaEnergyAdapter(this);
        }
        this.ic2Sink = Integrations.ic2().createPowerSink(this, this);
        this.ic2Sink.setValidFaces(this.internalPowerSides);
    }

    protected EnumSet<EnumFacing> getPowerSides() {
        return this.internalPowerSides.clone();
    }

    protected void setPowerSides(EnumSet<EnumFacing> sides) {
        this.internalPowerSides = sides;
        this.ic2Sink.setValidFaces(sides);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74780_a("internalCurrentPower", this.getInternalCurrentPower());
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.setInternalCurrentPower(data.func_74769_h("internalCurrentPower"));
    }

    @Override
    public final double getExternalPowerDemand(PowerUnits externalUnit, double maxPowerRequired) {
        return PowerUnits.AE.convertTo(externalUnit, Math.max(0.0, this.getFunnelPowerDemand(externalUnit.convertTo(PowerUnits.AE, maxPowerRequired))));
    }

    protected double getFunnelPowerDemand(double maxRequired) {
        return this.getInternalMaxPower() - this.getInternalCurrentPower();
    }

    @Override
    public final double injectExternalPower(PowerUnits input, double amt, Actionable mode) {
        return PowerUnits.AE.convertTo(input, this.funnelPowerIntoStorage(input.convertTo(PowerUnits.AE, amt), mode));
    }

    protected double funnelPowerIntoStorage(double power, Actionable mode) {
        return this.injectAEPower(power, mode);
    }

    @Override
    public final double injectAEPower(double amt, Actionable mode) {
        if (amt < 1.0E-6) {
            return 0.0;
        }
        double required = this.getAEMaxPower() - this.getAECurrentPower();
        double insertable = Math.min(required, amt);
        if (mode == Actionable.MODULATE) {
            if (this.getInternalCurrentPower() < 0.01 && insertable > 0.01) {
                this.PowerEvent(MENetworkPowerStorage.PowerEventType.PROVIDE_POWER);
            }
            this.setInternalCurrentPower(this.getInternalCurrentPower() + insertable);
        }
        return amt - insertable;
    }

    protected void PowerEvent(MENetworkPowerStorage.PowerEventType x) {
    }

    @Override
    public final double getAEMaxPower() {
        return this.getInternalMaxPower();
    }

    @Override
    public final double getAECurrentPower() {
        return this.getInternalCurrentPower();
    }

    @Override
    public final boolean isAEPublicPowerStorage() {
        return this.isInternalPublicPowerStorage();
    }

    @Override
    public final AccessRestriction getPowerFlow() {
        return this.getInternalPowerFlow();
    }

    @Override
    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier multiplier) {
        return multiplier.divide(this.extractAEPower(multiplier.multiply(amt), mode));
    }

    protected double extractAEPower(double amt, Actionable mode) {
        boolean wasFull;
        if (mode == Actionable.SIMULATE) {
            if (this.getInternalCurrentPower() > amt) {
                return amt;
            }
            return this.getInternalCurrentPower();
        }
        boolean bl = wasFull = this.getInternalCurrentPower() >= this.getInternalMaxPower() - 0.001;
        if (wasFull && amt > 0.001) {
            this.PowerEvent(MENetworkPowerStorage.PowerEventType.REQUEST_POWER);
        }
        if (this.getInternalCurrentPower() > amt) {
            this.setInternalCurrentPower(this.getInternalCurrentPower() - amt);
            return amt;
        }
        amt = this.getInternalCurrentPower();
        this.setInternalCurrentPower(0.0);
        return amt;
    }

    public double getInternalCurrentPower() {
        return this.internalCurrentPower;
    }

    public void setInternalCurrentPower(double internalCurrentPower) {
        this.internalCurrentPower = internalCurrentPower;
    }

    public double getInternalMaxPower() {
        return this.internalMaxPower;
    }

    public void setInternalMaxPower(double internalMaxPower) {
        this.internalMaxPower = internalMaxPower;
    }

    private boolean isInternalPublicPowerStorage() {
        return this.internalPublicPowerStorage;
    }

    public void setInternalPublicPowerStorage(boolean internalPublicPowerStorage) {
        this.internalPublicPowerStorage = internalPublicPowerStorage;
    }

    private AccessRestriction getInternalPowerFlow() {
        return this.internalPowerFlow;
    }

    public void setInternalPowerFlow(AccessRestriction internalPowerFlow) {
        this.internalPowerFlow = internalPowerFlow;
    }

    @Override
    public void onReady() {
        super.onReady();
        this.ic2Sink.onLoad();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.ic2Sink.onChunkUnload();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.ic2Sink.invalidate();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == Capabilities.FORGE_ENERGY ? this.getPowerSides().contains(facing) : capability == Capabilities.TESLA_CONSUMER && this.getPowerSides().contains(facing)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == Capabilities.FORGE_ENERGY) {
            if (this.getPowerSides().contains(facing)) {
                return (T)this.forgeEnergyAdapter;
            }
        } else if (capability == Capabilities.TESLA_CONSUMER && this.getPowerSides().contains(facing)) {
            return (T)this.teslaEnergyAdapter;
        }
        return super.getCapability(capability, facing);
    }
}

