/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.util.IReadOnlyCollection;
import appeng.me.GridNodeIterator;
import appeng.me.MachineSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GridNodeCollection
implements IReadOnlyCollection<IGridNode> {
    private final Map<Class<? extends IGridHost>, MachineSet> machines;

    public GridNodeCollection(Map<Class<? extends IGridHost>, MachineSet> machines) {
        this.machines = machines;
    }

    @Override
    public Iterator<IGridNode> iterator() {
        return new GridNodeIterator(this.machines);
    }

    @Override
    public int size() {
        int size = 0;
        for (Set set : this.machines.values()) {
            size += set.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        for (Set set : this.machines.values()) {
            if (set.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object maybeGridNode) {
        IGridNode node;
        IGridHost machine;
        Class<?> machineClass;
        MachineSet machineSet;
        boolean doesContainNode = maybeGridNode instanceof IGridNode ? (machineSet = this.machines.get(machineClass = (machine = (node = (IGridNode)maybeGridNode).getMachine()).getClass())) != null && machineSet.contains(maybeGridNode) : false;
        return doesContainNode;
    }
}

