/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.theoneprobe.part;

import appeng.api.parts.IPart;
import appeng.integration.modules.theoneprobe.TheOneProbeText;
import appeng.integration.modules.theoneprobe.part.IPartProbInfoProvider;
import appeng.me.GridAccessException;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.util.Platform;
import com.google.common.collect.Iterators;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class P2PStateInfoProvider
implements IPartProbInfoProvider {
    private static final int STATE_UNLINKED = 0;
    private static final int STATE_OUTPUT = 1;
    private static final int STATE_INPUT = 2;

    @Override
    public void addProbeInfo(IPart part, ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (part instanceof PartP2PTunnel) {
            PartP2PTunnel tunnel = (PartP2PTunnel)part;
            if (!tunnel.isPowered()) {
                return;
            }
            int state = 0;
            int outputCount = 0;
            if (!tunnel.isOutput()) {
                outputCount = P2PStateInfoProvider.getOutputCount(tunnel);
                if (outputCount > 0) {
                    state = 2;
                }
            } else {
                Object input = tunnel.getInput();
                if (input != null) {
                    state = 1;
                }
            }
            switch (state) {
                case 0: {
                    probeInfo.text(TheOneProbeText.P2P_UNLINKED.getLocal());
                    break;
                }
                case 1: {
                    probeInfo.text(TheOneProbeText.P2P_OUTPUT.getLocal());
                    break;
                }
                case 2: {
                    probeInfo.text(P2PStateInfoProvider.getOutputText(outputCount));
                }
            }
            short freq = tunnel.getFrequency();
            String freqTooltip = Platform.p2p().toHexString(freq);
            probeInfo.text(freqTooltip);
        }
    }

    private static int getOutputCount(PartP2PTunnel tunnel) {
        try {
            return Iterators.size(tunnel.getOutputs().iterator());
        }
        catch (GridAccessException e) {
            return 0;
        }
    }

    private static String getOutputText(int outputs) {
        if (outputs <= 1) {
            return TheOneProbeText.P2P_INPUT_ONE_OUTPUT.getLocal();
        }
        return String.format(TheOneProbeText.P2P_INPUT_MANY_OUTPUTS.getLocal(), outputs);
    }
}

