/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.block.misc.BlockSkyCompass;
import appeng.client.render.model.MatrixVertexTransformer;
import appeng.hooks.CompassManager;
import appeng.hooks.CompassResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class SkyCompassBakedModel
implements IBakedModel {
    private final IBakedModel base;
    private final IBakedModel pointer;
    private float fallbackRotation = 0.0f;

    public SkyCompassBakedModel(IBakedModel base, IBakedModel pointer) {
        this.base = base;
        this.pointer = pointer;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        float rotation = 0.0f;
        if (state instanceof IExtendedBlockState) {
            Float rotationOpt = (Float)((IExtendedBlockState)state).getValue((IUnlistedProperty)BlockSkyCompass.ROTATION);
            if (rotationOpt != null) {
                rotation = rotationOpt.floatValue();
            }
        } else if (state == null) {
            rotation = this.fallbackRotation;
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        quads.addAll(this.base.func_188616_a(state, side, rand));
        if (side == null) {
            Matrix4f matrix = new Matrix4f();
            matrix.setIdentity();
            matrix.setRotation(new AxisAngle4f(0.0f, 1.0f, 0.0f, rotation));
            MatrixVertexTransformer transformer = new MatrixVertexTransformer(matrix);
            for (BakedQuad bakedQuad : this.pointer.func_188616_a(state, side, rand)) {
                UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(bakedQuad.getFormat());
                transformer.setParent((IVertexConsumer)builder);
                transformer.setVertexFormat(builder.getVertexFormat());
                bakedQuad.pipe((IVertexConsumer)transformer);
                builder.setQuadOrientation(null);
                UnpackedBakedQuad q = builder.build();
                quads.add((BakedQuad)q);
            }
        }
        return quads;
    }

    public boolean func_177555_b() {
        return this.base.func_177555_b();
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.base.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.base.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList(Collections.emptyList()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
                if (world != null && entity instanceof EntityPlayerSP) {
                    EntityPlayer player = (EntityPlayer)entity;
                    float offRads = (float)((double)(player.field_70177_z / 180.0f * (float)Math.PI) + Math.PI);
                    SkyCompassBakedModel.this.fallbackRotation = offRads + SkyCompassBakedModel.getAnimatedRotation(player.func_180425_c(), true);
                } else {
                    SkyCompassBakedModel.this.fallbackRotation = SkyCompassBakedModel.getAnimatedRotation(null, false);
                }
                return originalModel;
            }
        };
    }

    public static float getAnimatedRotation(@Nullable BlockPos pos, boolean prefetch) {
        if (pos != null) {
            CompassResult cr = CompassManager.INSTANCE.getCompassDirection(0L, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            if (prefetch) {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        CompassManager.INSTANCE.getCompassDirection(0L, pos.func_177958_n() + i - 1, pos.func_177956_o(), pos.func_177952_p() + j - 1);
                    }
                }
            }
            if (cr.isValidResult()) {
                if (cr.isSpin()) {
                    long timeMillis = System.currentTimeMillis();
                    return (float)(timeMillis %= 500L) / 500.0f * (float)Math.PI * 2.0f;
                }
                return (float)cr.getRad();
            }
        }
        long timeMillis = System.currentTimeMillis();
        return (float)(timeMillis %= 3000L) / 3000.0f * (float)Math.PI * 2.0f;
    }
}

