/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe.xml;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.recipe.xml.IItemTypeHandler;
import org.cyclops.cyclopscore.recipe.xml.XmlRecipeLoader;
import org.w3c.dom.Node;

public class DefaultItemTypeHandler
implements IItemTypeHandler {
    protected Ingredient createItemIngredient(ItemStack itemStack, boolean nbtSensitive) {
        return nbtSensitive ? new IngredientNBT(itemStack) : Ingredient.func_193369_a((ItemStack[])new ItemStack[]{itemStack});
    }

    protected Ingredient makeIngredient(RecipeHandler recipeHandler, String key, int amount, int meta, boolean nbtSensitive) throws XmlRecipeLoader.XmlRecipeException {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(key));
        if (item == null) {
            throw new XmlRecipeLoader.XmlRecipeException(String.format("Item by name '%s' has not been found.", key));
        }
        return this.createItemIngredient(new ItemStack(item, amount, meta), nbtSensitive);
    }

    @Override
    public Ingredient getIngredient(RecipeHandler recipeHandler, Node itemNode) throws XmlRecipeLoader.XmlRecipeException {
        String element = itemNode.getTextContent();
        if (element == null || element.isEmpty()) {
            return Ingredient.field_193370_a;
        }
        int amount = 1;
        Node amountNode = itemNode.getAttributes().getNamedItem("amount");
        if (amountNode != null) {
            amount = Integer.parseInt(amountNode.getTextContent());
        }
        int meta = 0;
        Node metaNode = itemNode.getAttributes().getNamedItem("meta");
        if (metaNode != null) {
            meta = "*".equals(metaNode.getTextContent()) ? Short.MAX_VALUE : Integer.parseInt(metaNode.getTextContent());
        }
        boolean nbtSensitive = itemNode.getAttributes().getNamedItem("nbt_sensitive") != null && itemNode.getAttributes().getNamedItem("nbt_sensitive").getTextContent().equals("true");
        return this.makeIngredient(recipeHandler, element, amount, meta, nbtSensitive);
    }

    public static class IngredientNBT
    extends net.minecraftforge.common.crafting.IngredientNBT {
        public IngredientNBT(ItemStack stack) {
            super(stack);
        }
    }
}

