/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.proxy;

import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import org.cyclops.cyclopscore.client.key.IKeyRegistry;
import org.cyclops.cyclopscore.event.ConfigChangedEventHook;
import org.cyclops.cyclopscore.event.PlayerRingOfFire;
import org.cyclops.cyclopscore.item.IBucketRegistry;
import org.cyclops.cyclopscore.network.PacketHandler;
import org.cyclops.cyclopscore.network.packet.SendPlayerCapabilitiesPacket;
import org.cyclops.cyclopscore.proxy.ICommonProxy;
import org.cyclops.cyclopscore.world.gen.IRetroGenRegistry;

public abstract class CommonProxyComponent
implements ICommonProxy {
    @Override
    public void registerRenderer(Class<? extends TileEntity> clazz, TileEntitySpecialRenderer renderer) {
        throw new IllegalArgumentException("Registration of renderers should not be called server side!");
    }

    @Override
    public void registerRenderers() {
    }

    @Override
    public void registerKeyBindings(IKeyRegistry keyRegistry) {
    }

    @Override
    public void registerPacketHandlers(PacketHandler packetHandler) {
        packetHandler.register(SendPlayerCapabilitiesPacket.class);
    }

    @Override
    public void registerTickHandlers() {
    }

    @Override
    public void registerEventHooks() {
        IBucketRegistry bucketRegistry;
        IRetroGenRegistry retroGenRegistry = this.getMod().getRegistryManager().getRegistry(IRetroGenRegistry.class);
        if (retroGenRegistry != null) {
            MinecraftForge.EVENT_BUS.register((Object)retroGenRegistry);
        }
        if ((bucketRegistry = this.getMod().getRegistryManager().getRegistry(IBucketRegistry.class)) != null) {
            MinecraftForge.EVENT_BUS.register((Object)bucketRegistry);
        }
        MinecraftForge.EVENT_BUS.register((Object)new PlayerRingOfFire());
        MinecraftForge.EVENT_BUS.register((Object)new ConfigChangedEventHook(this.getMod()));
    }
}

