/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import baubles.api.BaublesApi;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles", striprefs=true)
public class PlayerExtendedInventoryIterator
implements Iterator<ItemStack> {
    private PlayerInventoryIterator innerIt;
    private boolean hasIteratedInner = false;
    private int maxBaublesSize;
    private int baublesIterator = this.maxBaublesSize = 4;

    public PlayerExtendedInventoryIterator(EntityPlayer player) {
        this.innerIt = new PlayerInventoryIterator(player);
        if (Loader.isModLoaded((String)"baubles")) {
            this.setBaublesData();
        }
    }

    @Override
    public boolean hasNext() {
        return !this.hasIteratedInner || this.baublesIterator < this.maxBaublesSize;
    }

    @Override
    public ItemStack next() {
        if (this.hasIteratedInner && this.hasNext()) {
            ItemStack itemStack = this.getBaublesStack(this.baublesIterator);
            ++this.baublesIterator;
            return itemStack;
        }
        ItemStack next = this.innerIt.next();
        if (!this.innerIt.hasNext()) {
            this.hasIteratedInner = true;
        }
        return next;
    }

    @Optional.Method(modid="baubles")
    protected ItemStack getBaublesStack(int index) {
        return BaublesApi.getBaubles((EntityPlayer)this.innerIt.getPlayer()).func_70301_a(index);
    }

    @Optional.Method(modid="baubles")
    protected void setBaublesStack(int index, ItemStack itemStack) {
        BaublesApi.getBaubles((EntityPlayer)this.innerIt.getPlayer()).func_70299_a(index, itemStack);
    }

    @Optional.Method(modid="baubles")
    protected void setBaublesData() {
        this.maxBaublesSize = BaublesApi.getBaubles((EntityPlayer)this.innerIt.getPlayer()).func_70302_i_();
        this.baublesIterator = 0;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented.");
    }

    public void replace(ItemStack itemStack) {
        if (this.hasIteratedInner && this.baublesIterator > 0) {
            this.setBaublesStack(this.baublesIterator - 1, itemStack);
        } else {
            this.innerIt.replace(itemStack);
        }
    }
}

