/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponentCategoryType;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionLikeSingleClassifiedIterator;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionLikeSingleClassifiedTrait;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientMapMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientHashSet;
import org.cyclops.cyclopscore.ingredient.collection.IngredientMapAdapter;
import org.cyclops.cyclopscore.ingredient.collection.IngredientSet;

public class IngredientMapSingleClassified<T, M, V, C>
extends IngredientMapAdapter<T, M, V>
implements IIngredientCollectionLikeSingleClassifiedTrait<T, M, Map.Entry<T, V>, C, IIngredientMapMutable<T, M, V>> {
    private final Map<C, IIngredientMapMutable<T, M, V>> classifiedMaps;
    private final Supplier<IIngredientMapMutable<T, M, V>> mapCreator;
    private final IngredientComponentCategoryType<T, M, C> categoryType;
    private int size;

    public IngredientMapSingleClassified(IngredientComponent<T, M> component, Supplier<IIngredientMapMutable<T, M, V>> mapCreator, IngredientComponentCategoryType<T, M, C> categoryType) {
        super(component);
        this.classifiedMaps = categoryType.isReferenceEqual() ? Maps.newIdentityHashMap() : Maps.newHashMap();
        this.mapCreator = mapCreator;
        this.categoryType = categoryType;
        this.size = 0;
    }

    @Override
    public IngredientComponentCategoryType<T, M, C> getCategoryType() {
        return this.categoryType;
    }

    @Override
    public IIngredientMapMutable<T, M, V> createEmptyCollection() {
        return this.mapCreator.get();
    }

    @Override
    public T getInstance(Map.Entry<T, V> iterableInstance) {
        return iterableInstance.getKey();
    }

    @Override
    public Map<C, IIngredientMapMutable<T, M, V>> getClassifiedCollections() {
        return this.classifiedMaps;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public void clear() {
        this.classifiedMaps.clear();
        this.size = 0;
    }

    @Override
    @Nullable
    public V put(T key, V value) {
        V previousValue = ((IIngredientMapMutable)this.getOrCreateClassifiedCollection(this.getClassifier(key))).put(key, value);
        if (previousValue == null) {
            ++this.size;
        }
        return previousValue;
    }

    @Override
    @Nullable
    public V remove(T key) {
        Object classifier = this.getClassifier(key);
        IIngredientMapMutable<T, M, V> map = this.classifiedMaps.get(classifier);
        if (map != null) {
            V removed = map.remove(key);
            if (removed != null) {
                --this.size;
                if (map.isEmpty()) {
                    this.classifiedMaps.remove(classifier);
                }
            }
            return removed;
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsKey(T instance, M matchCondition) {
        IIngredientMapMutable<T, Object, V> map;
        if (this.appliesToClassifier(matchCondition) && (map = this.classifiedMaps.get(this.getClassifier(instance))) != null) {
            if (Objects.equals(this.getCategoryType().getMatchCondition(), matchCondition)) {
                return true;
            }
            Object subMatchCondition = this.getComponent().getMatcher().withoutCondition(matchCondition, this.getCategoryType().getMatchCondition());
            return map.containsKey(instance, subMatchCondition);
        }
        return super.containsKey(instance, matchCondition);
    }

    @Override
    public int countKey(T instance, M matchCondition) {
        IIngredientMapMutable<T, Object, V> map;
        if (this.appliesToClassifier(matchCondition) && (map = this.classifiedMaps.get(this.getClassifier(instance))) != null) {
            if (Objects.equals(this.getCategoryType().getMatchCondition(), matchCondition)) {
                return map.size();
            }
            Object subMatchCondition = this.getComponent().getMatcher().withoutCondition(matchCondition, this.getCategoryType().getMatchCondition());
            return map.countKey(instance, subMatchCondition);
        }
        return super.countKey(instance, matchCondition);
    }

    @Override
    public boolean containsValue(V value) {
        for (IIngredientMapMutable<T, M, V> map : this.classifiedMaps.values()) {
            if (!map.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public V get(T key) {
        Object classifier = this.getClassifier(key);
        IIngredientMapMutable<T, M, V> map = this.classifiedMaps.get(classifier);
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    @Override
    public IngredientSet<T, M> keySet() {
        IngredientHashSet keys = new IngredientHashSet(this.getComponent());
        for (IIngredientMapMutable<T, M, V> map : this.classifiedMaps.values()) {
            keys.addAll(map.keySet());
        }
        return keys;
    }

    @Override
    public Collection<V> values() {
        ArrayList values = Lists.newArrayList();
        for (IIngredientMapMutable<T, M, V> map : this.classifiedMaps.values()) {
            values.addAll(map.values());
        }
        return values;
    }

    @Override
    public Collection<V> getAll(T key, M matchCondition) {
        IIngredientMapMutable<T, Object, V> map;
        if (this.appliesToClassifier(matchCondition) && (map = this.classifiedMaps.get(this.getClassifier(key))) != null) {
            if (Objects.equals(this.getCategoryType().getMatchCondition(), matchCondition)) {
                return map.values();
            }
            Object subMatchCondition = this.getComponent().getMatcher().withoutCondition(matchCondition, this.getCategoryType().getMatchCondition());
            return map.getAll(key, subMatchCondition);
        }
        return super.getAll(key, matchCondition);
    }

    @Override
    public IngredientSet<T, M> keySet(T key, M matchCondition) {
        IIngredientMapMutable<T, Object, V> map;
        if (this.appliesToClassifier(matchCondition) && (map = this.classifiedMaps.get(this.getClassifier(key))) != null) {
            if (Objects.equals(this.getCategoryType().getMatchCondition(), matchCondition)) {
                return map.keySet();
            }
            Object subMatchCondition = this.getComponent().getMatcher().withoutCondition(matchCondition, this.getCategoryType().getMatchCondition());
            return map.keySet(key, subMatchCondition);
        }
        return super.keySet(key, matchCondition);
    }

    @Override
    public Iterator<Map.Entry<T, V>> iterator() {
        return new IIngredientCollectionLikeSingleClassifiedTrait.ClassifiedIterator(this);
    }

    @Override
    public Iterator<Map.Entry<T, V>> iterator(T instance, M matchCondition) {
        if (this.appliesToClassifier(matchCondition)) {
            IIngredientMapMutable<T, M, V> collection = this.getClassifiedCollections().get(this.getClassifier(instance));
            if (collection != null) {
                return new IIngredientCollectionLikeSingleClassifiedTrait.ClassifiedIteratorDelegated(this, collection, instance, matchCondition);
            }
            return Iterators.forArray((Object[])new Map.Entry[0]);
        }
        return new FilteredIngredientCollectionLikeSingleClassifiedIterator(this, this.getComponent().getMatcher(), instance, matchCondition);
    }
}

