/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponentCategoryType;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionLikeSingleClassifiedIterator;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollection;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionLikeSingleClassifiedTrait;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionAdapter;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollections;

public class IngredientCollectionSingleClassified<T, M, C>
extends IngredientCollectionAdapter<T, M>
implements IIngredientCollectionLikeSingleClassifiedTrait<T, M, T, C, IIngredientCollectionMutable<T, M>> {
    private final Map<C, IIngredientCollectionMutable<T, M>> classifiedCollections;
    private final Supplier<IIngredientCollectionMutable<T, M>> collectionCreator;
    private final IngredientComponentCategoryType<T, M, C> categoryType;
    private int size;

    public IngredientCollectionSingleClassified(IngredientComponent<T, M> component, Supplier<IIngredientCollectionMutable<T, M>> collectionCreator, IngredientComponentCategoryType<T, M, C> categoryType) {
        super(component);
        this.classifiedCollections = categoryType.isReferenceEqual() ? Maps.newIdentityHashMap() : Maps.newHashMap();
        this.collectionCreator = collectionCreator;
        this.categoryType = categoryType;
        this.size = 0;
    }

    @Override
    public IngredientComponentCategoryType<T, M, C> getCategoryType() {
        return this.categoryType;
    }

    @Override
    public IIngredientCollectionMutable<T, M> createEmptyCollection() {
        return this.collectionCreator.get();
    }

    @Override
    public T getInstance(T iterableInstance) {
        return iterableInstance;
    }

    @Override
    public Map<C, IIngredientCollectionMutable<T, M>> getClassifiedCollections() {
        return this.classifiedCollections;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(T instance) {
        if (((IIngredientCollectionMutable)this.getOrCreateClassifiedCollection(this.getClassifier(instance))).add(instance)) {
            ++this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(T instance) {
        Object classifier = this.getClassifier(instance);
        IIngredientCollectionMutable<T, M> collection = this.classifiedCollections.get(classifier);
        if (collection != null && collection.remove(instance)) {
            --this.size;
            if (collection.isEmpty()) {
                this.classifiedCollections.remove(classifier);
            }
            return true;
        }
        return false;
    }

    @Override
    public int removeAll(T instance, M matchCondition) {
        if (Objects.equals(this.getComponent().getMatcher().getAnyMatchCondition(), matchCondition)) {
            int size = this.size();
            this.clear();
            return size;
        }
        if (this.appliesToClassifier(matchCondition)) {
            int removed = 0;
            Object classifier = this.getClassifier(instance);
            IIngredientCollectionMutable<T, Object> collection = this.classifiedCollections.get(classifier);
            if (collection != null) {
                if (Objects.equals(this.getCategoryType().getMatchCondition(), matchCondition)) {
                    removed = collection.size();
                    collection.clear();
                } else {
                    Object subMatchCondition = this.getComponent().getMatcher().withoutCondition(matchCondition, this.getCategoryType().getMatchCondition());
                    removed = collection.removeAll(instance, subMatchCondition);
                }
                if (collection.isEmpty()) {
                    this.classifiedCollections.remove(classifier);
                }
            }
            this.size -= removed;
            return removed;
        }
        return super.removeAll(instance, matchCondition);
    }

    @Override
    public boolean contains(T instance) {
        IIngredientCollectionMutable<T, M> collection = this.classifiedCollections.get(this.getClassifier(instance));
        return collection != null && collection.contains(instance);
    }

    @Override
    public boolean contains(T instance, M matchCondition) {
        IIngredientCollectionMutable<T, Object> collection;
        if (Objects.equals(this.getComponent().getMatcher().getAnyMatchCondition(), matchCondition)) {
            return !this.isEmpty();
        }
        if (this.appliesToClassifier(matchCondition) && (collection = this.classifiedCollections.get(this.getClassifier(instance))) != null) {
            if (Objects.equals(this.getCategoryType().getMatchCondition(), matchCondition)) {
                return true;
            }
            Object subMatchCondition = this.getComponent().getMatcher().withoutCondition(matchCondition, this.getCategoryType().getMatchCondition());
            return collection.contains(instance, subMatchCondition);
        }
        return super.contains(instance, matchCondition);
    }

    @Override
    public void clear() {
        this.classifiedCollections.clear();
        this.size = 0;
    }

    @Override
    public int count(T instance, M matchCondition) {
        IIngredientCollectionMutable<T, Object> collection;
        if (Objects.equals(this.getComponent().getMatcher().getAnyMatchCondition(), matchCondition)) {
            return this.size();
        }
        if (this.appliesToClassifier(matchCondition) && (collection = this.classifiedCollections.get(this.getClassifier(instance))) != null) {
            if (Objects.equals(this.getCategoryType().getMatchCondition(), matchCondition)) {
                return collection.size();
            }
            Object subMatchCondition = this.getComponent().getMatcher().withoutCondition(matchCondition, this.getCategoryType().getMatchCondition());
            return collection.count(instance, subMatchCondition);
        }
        return super.count(instance, matchCondition);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof IngredientCollectionSingleClassified && this.getCategoryType() == ((IngredientCollectionSingleClassified)obj).getCategoryType() && IngredientCollections.equalsCheckedOrdered(this, (IIngredientCollection)obj);
    }

    @Override
    public Iterator<T> iterator() {
        return new IIngredientCollectionLikeSingleClassifiedTrait.ClassifiedIterator(this);
    }

    @Override
    public Iterator<T> iterator(T instance, M matchCondition) {
        if (this.getComponent().getMatcher().getAnyMatchCondition().equals(matchCondition)) {
            return this.iterator();
        }
        if (this.appliesToClassifier(matchCondition)) {
            IIngredientCollectionMutable<T, M> collection = this.getClassifiedCollections().get(this.getClassifier(instance));
            if (collection != null) {
                return new IIngredientCollectionLikeSingleClassifiedTrait.ClassifiedIteratorDelegated(this, collection, instance, matchCondition);
            }
            return Iterators.forArray((Object[])new Object[0]);
        }
        return new FilteredIngredientCollectionLikeSingleClassifiedIterator(this, this.getComponent().getMatcher(), instance, matchCondition);
    }
}

