/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import java.util.Iterator;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionIterator;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollections;

public abstract class IngredientCollectionAdapter<T, M>
implements IIngredientCollectionMutable<T, M> {
    private final IngredientComponent<T, M> component;

    public IngredientCollectionAdapter(IngredientComponent<T, M> component) {
        this.component = component;
    }

    @Override
    public IngredientComponent<T, M> getComponent() {
        return this.component;
    }

    @Override
    public boolean remove(T instance) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (!matcher.matchesExactly(instance, it.next())) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public int removeAll(T instance, M matchCondition) {
        Iterator<T> it = this.iterator(instance, matchCondition);
        int count = 0;
        while (it.hasNext()) {
            it.next();
            it.remove();
            ++count;
        }
        return count;
    }

    @Override
    public boolean contains(T instance) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        for (Object thisInstance : this) {
            if (!matcher.matchesExactly(instance, thisInstance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(T instance, M matchCondition) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        for (Object thisInstance : this) {
            if (!matcher.matches(instance, thisInstance, matchCondition)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int count(T instance, M matchCondition) {
        int count = 0;
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        for (Object thisInstance : this) {
            if (!matcher.matches(instance, thisInstance, matchCondition)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<T> iterator(T instance, M matchCondition) {
        return new FilteredIngredientCollectionIterator<T, M>(this, this.getComponent().getMatcher(), instance, matchCondition);
    }

    @Override
    public int hashCode() {
        return IngredientCollections.hash(this);
    }

    @Override
    public String toString() {
        return IngredientCollections.toString(this);
    }
}

