/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.AdvancementHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.GuiInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.pageelement.AdvancementRewards;
import org.cyclops.cyclopscore.infobook.pageelement.IReward;

@SideOnly(value=Side.CLIENT)
public class AchievementCollectButton
extends AdvancedButton {
    private final AdvancementRewards advancementRewards;
    private final IInfoBook infoBook;

    public AchievementCollectButton(AdvancementRewards advancementRewards, IInfoBook infoBook) {
        this.advancementRewards = advancementRewards;
        this.infoBook = infoBook;
    }

    protected IInfoBook getInfoBook() {
        return this.infoBook;
    }

    @Override
    public void renderTooltip(int mx, int my) {
        super.renderTooltip(mx, my);
        GlStateManager.func_179094_E();
        if (mx >= this.field_146128_h && my >= this.field_146129_i && mx <= this.field_146128_h + this.field_146120_f && my <= this.field_146129_i + this.field_146121_g) {
            ArrayList lines = Lists.newArrayList();
            if (this.advancementRewards.isObtained((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                lines.add(TextFormatting.ITALIC + L10NHelpers.localize("gui." + this.getInfoBook().getMod().getModId() + ".rewards.collected", new Object[0]));
            } else {
                lines.add(TextFormatting.BOLD + L10NHelpers.localize("gui." + this.getInfoBook().getMod().getModId() + ".rewards.collect", new Object[0]));
                boolean canObtain = true;
                for (IReward reward : this.advancementRewards.getRewards()) {
                    if (reward.canObtain((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) continue;
                    canObtain = false;
                }
                if (!canObtain) {
                    lines.add(TextFormatting.RED + L10NHelpers.localize("gui." + this.getInfoBook().getMod().getModId() + ".rewards.collectFailure", new Object[0]));
                }
            }
            this.gui.func_146283_a(lines, mx, my);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    @Override
    public boolean isVisible() {
        return this.field_146125_m;
    }

    @Override
    public void onClick() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean canObtain = true;
        for (ResourceLocation advancement : this.advancementRewards.getAdvancements()) {
            if (AdvancementHelpers.hasAdvancementUnlocked((EntityPlayer)Minecraft.func_71410_x().field_71439_g, advancement)) continue;
            canObtain = false;
        }
        for (IReward reward : this.advancementRewards.getRewards()) {
            if (reward.canObtain((EntityPlayer)player)) continue;
            canObtain = false;
        }
        if (canObtain) {
            this.advancementRewards.obtain((EntityPlayer)player);
        }
    }

    @Override
    public void update(int x, int y, String displayName, InfoSection target, GuiInfoBook gui) {
        super.update(x, y, displayName, target, gui);
        this.field_146120_f = 80;
    }
}

