/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class MobConfig<T extends EntityLivingBase>
extends ExtendedConfig<MobConfig<T>> {
    public MobConfig(ModBase mod, boolean enabled, String namedId, String comment, Class<? extends T> element) {
        super(mod, enabled, namedId, comment, element);
    }

    @Override
    public String getUnlocalizedName() {
        return "entity.mob." + this.getMod().getModId() + "." + this.getNamedId();
    }

    @Override
    public ConfigurableType getHolderType() {
        return ConfigurableType.MOB;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRegistered() {
        super.onRegistered();
        Class<?> clazz = this.getElement();
        RenderingRegistry.registerEntityRenderingHandler(clazz, (IRenderFactory)new IRenderFactory<T>(){

            public Render<? super T> createRenderFor(RenderManager manager) {
                return MobConfig.this.getRender(manager);
            }
        });
    }

    public boolean hasSpawnEgg() {
        return true;
    }

    public abstract int getBackgroundEggColor();

    public abstract int getForegroundEggColor();

    @SideOnly(value=Side.CLIENT)
    public abstract Render<? super T> getRender(RenderManager var1);

    @Override
    public IForgeRegistry<?> getRegistry() {
        return ForgeRegistries.ENTITIES;
    }
}

