/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.machine.compactor;

import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiCompactor;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.machine.BaseRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.compactor.CompactorRecipeCategoryCoin;
import cofh.thermalexpansion.plugins.jei.machine.compactor.CompactorRecipeCategoryGear;
import cofh.thermalexpansion.plugins.jei.machine.compactor.CompactorRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.CompactorManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class CompactorRecipeCategory
extends BaseRecipeCategory<CompactorRecipeWrapper> {
    public static boolean enable = true;
    protected IDrawableStatic progress;
    protected IDrawableStatic speed;

    public static void register(IRecipeCategoryRegistration registry) {
        String category = "Plugins.JEI";
        if (!(enable = ThermalExpansion.CONFIG_CLIENT.get(category, "Machine.Compactor", enable))) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CompactorRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CompactorRecipeCategoryCoin(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CompactorRecipeCategoryGear(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(CompactorRecipeCategory.getRecipes(guiHelper), "thermalexpansion.compactor");
        registry.addRecipeClickArea(GuiCompactor.class, 79, 34, 24, 16, new String[]{"thermalexpansion.compactor", "thermalexpansion.compactor_mint", "thermalexpansion.compactor_gear"});
        registry.addRecipeCatalyst((Object)BlockMachine.machineCompactor, new String[]{"thermalexpansion.compactor"});
        CompactorRecipeCategoryCoin.initialize(registry);
        CompactorRecipeCategoryGear.initialize(registry);
    }

    public static List<CompactorRecipeWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<CompactorRecipeWrapper> recipes = new ArrayList<CompactorRecipeWrapper>();
        for (CompactorManager.CompactorRecipe recipe : CompactorManager.getRecipeList(CompactorManager.Mode.ALL)) {
            recipes.add(new CompactorRecipeWrapper(guiHelper, recipe, "thermalexpansion.compactor"));
        }
        for (CompactorManager.CompactorRecipe recipe : CompactorManager.getRecipeList(CompactorManager.Mode.PLATE)) {
            recipes.add(new CompactorRecipeWrapper(guiHelper, recipe, "thermalexpansion.compactor"));
        }
        return recipes;
    }

    public CompactorRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiCompactor.TEXTURE, 26, 11, 124, 62, 0, 0, 16, 24);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.compactor.name");
        this.progress = Drawables.getDrawables(guiHelper).getProgress(0);
        this.speed = Drawables.getDrawables(guiHelper).getScale(2);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.compactor";
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.progress.draw(minecraft, 69, 23);
        this.speed.draw(minecraft, 43, 33);
        this.energyMeter.draw(minecraft, 2, 8);
    }

    public void setRecipe(IRecipeLayout recipeLayout, CompactorRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 42, 14);
        guiItemStacks.init(1, false, 105, 23);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(1, (List)outputs.get(0));
    }
}

