/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client.storage;

import cofh.api.core.ISecurable;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementButton;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.gui.element.tab.TabInfo;
import cofh.core.gui.element.tab.TabSecurity;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.storage.TileCache;
import cofh.thermalexpansion.gui.container.storage.ContainerCache;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GuiCache
extends GuiContainerCore {
    public static final String TEX_PATH = "thermalexpansion:textures/gui/storage/cache.png";
    public static final ResourceLocation TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/storage/cache.png");
    protected TileCache baseTile;
    protected UUID playerName;
    protected TabBase securityTab;
    private ElementButton lock;
    private ElementButton decMax;
    private ElementButton incMax;

    public GuiCache(InventoryPlayer inventory, TileEntity tile) {
        super((Container)new ContainerCache(inventory, tile), TEXTURE);
        this.baseTile = (TileCache)tile;
        this.name = this.baseTile.func_70005_c_();
        this.playerName = SecurityHelper.getID((EntityPlayer)inventory.field_70458_d);
        this.generateInfo("tab.thermalexpansion.storage.cache");
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.securityTab = this.addTab((TabBase)new TabSecurity((GuiContainerCore)this, (ISecurable)this.baseTile, this.playerName));
        this.securityTab.setVisible(this.baseTile.enableSecurity() && this.baseTile.isSecured());
        if (!this.myInfo.isEmpty()) {
            this.addTab((TabBase)new TabInfo((GuiContainerCore)this, this.myInfo));
        }
        this.lock = new ElementButton((GuiContainerCore)this, 44, 54, "Lock", 176, 48, 176, 64, 176, 80, 16, 16, TEX_PATH).setToolTipLocalized(true);
        this.decMax = new ElementButton((GuiContainerCore)this, 109, 56, "DecMax", 176, 0, 176, 14, 176, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.incMax = new ElementButton((GuiContainerCore)this, 125, 56, "IncMax", 190, 0, 190, 14, 190, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.addElement((ElementBase)this.lock);
        this.addElement((ElementBase)this.decMax);
        this.addElement((ElementBase)this.incMax);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.baseTile.canAccess()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.securityTab.setVisible(this.baseTile.enableSecurity() && this.baseTile.isSecured());
    }

    protected void updateElementInformation() {
        super.updateElementInformation();
        if (this.baseTile.getStoredInstance().func_190926_b()) {
            this.lock.setDisabled();
        } else {
            this.lock.setActive();
        }
        if (this.baseTile.isLocked()) {
            this.lock.setToolTip(StringHelper.localize((String)"info.cofh.locked"));
            this.lock.setSheetX(176);
            this.lock.setHoverX(176);
        } else {
            this.lock.setToolTip(StringHelper.localize((String)"info.cofh.unlocked"));
            this.lock.setSheetX(192);
            this.lock.setHoverX(192);
        }
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        if (buttonName.equalsIgnoreCase("Lock")) {
            this.baseTile.toggleLock();
            GuiCache.playClickSound((float)(this.baseTile.isLocked() ? 0.8f : 0.4f));
            this.baseTile.sendModePacket();
            this.baseTile.toggleLock();
        }
    }
}

